/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.cldc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

final class JwcProperties {
    private static final Logger logger = Logger.getLogger(JwcProperties.class);
    private Map<String, Section> sections = new HashMap<String, Section>();
    private static final String NO_PREFIX_SECTION = "";

    public void load(BufferedReader bufferedReader) throws IOException {
        String string;
        HashMap<String, Section> hashMap = new HashMap<String, Section>();
        String string2 = NO_PREFIX_SECTION;
        Section section = new Section();
        while ((string = bufferedReader.readLine()) != null) {
            if (JwcProperties.skipLine(string = string.trim())) continue;
            String string3 = JwcProperties.getSectionName(string);
            if (string3 != null) {
                if (string3.equals(string2)) continue;
                hashMap.put(string2, section);
                string2 = string3;
                section = (Section)hashMap.get(string2);
                if (section != null) continue;
                section = new Section();
                continue;
            }
            try {
                JwcProperties.addPropertyFromString(section, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.debug((Object)illegalArgumentException.getMessage());
            }
        }
        hashMap.put(string2, section);
        this.sections = hashMap;
    }

    public void save(PrintWriter printWriter) throws IOException {
        Section section = this.sections.get(NO_PREFIX_SECTION);
        if (section != null) {
            JwcProperties.saveSection(printWriter, section);
            printWriter.println();
        }
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            String string = entry.getKey();
            if (string.length() == 0) continue;
            printWriter.println("[" + string + "]");
            JwcProperties.saveSection(printWriter, entry.getValue());
            printWriter.println();
        }
    }

    private static void addPropertyFromString(Section section, String string) throws IllegalArgumentException {
        int n = string.indexOf(61);
        if (n == -1) {
            throw new IllegalArgumentException("The \"" + string + "\"" + " is an invalid \"<key> = <value>\" pair!");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        String string4 = JwcProperties.unescapeString(string3);
        section.setProperty(string2, string4);
    }

    private static String getSectionName(String string) {
        if (!string.startsWith("[") || !string.endsWith("]")) {
            return null;
        }
        return string.substring(1, string.length() - 1);
    }

    private static boolean skipLine(String string) {
        if (string.length() == 0) {
            return true;
        }
        char c = string.charAt(0);
        switch (c) {
            case '#': 
            case '%': 
            case ';': {
                return true;
            }
        }
        return false;
    }

    private static String unescapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (bl) {
                stringBuffer.append(JwcProperties.unescapeCharacter(cArray[i]));
                bl = false;
                continue;
            }
            if (cArray[i] == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private static char unescapeCharacter(char c) {
        switch (c) {
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
        }
        return c;
    }

    private static void saveSection(PrintWriter printWriter, Section section) throws IOException {
        Iterator<Map.Entry<String, String>> iterator = section.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String string = JwcProperties.escapeString(entry.getValue());
            printWriter.print(entry.getKey());
            printWriter.print(" = ");
            printWriter.println(string);
        }
    }

    private static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        block5: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block5;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block5;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String prependPrefix(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        if (string.length() == 0) {
            return string2;
        }
        return string + "." + string2;
    }

    private static void updateProperties(Section section, Properties properties, String string) {
        Iterator<Map.Entry<String, String>> iterator = section.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String string2 = JwcProperties.prependPrefix(string, entry.getKey());
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            if (string3.equalsIgnoreCase("NULL")) {
                iterator.remove();
                logger.trace((Object)("Removed property \"" + entry.getKey() + "\""));
            } else {
                entry.setValue(string3);
            }
            properties.remove(string2);
        }
    }

    public void mergeProperties(Properties properties, String string) {
        String string2 = null;
        String string3 = null;
        Map.Entry<Object, Object> entry2 = null;
        for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
            String string4;
            string2 = (String)entry2.getKey();
            string3 = (String)entry2.getValue();
            if (!string2.startsWith(string)) continue;
            String string5 = this.getSectionName(string2, string);
            Section section = this.sections.get(string5);
            if (section == null) {
                string5 = NO_PREFIX_SECTION;
                section = this.sections.get(NO_PREFIX_SECTION);
                if (section == null) {
                    section = new Section();
                    this.sections.put(string5, section);
                }
            }
            if ((string4 = this.getCleanPropertyName(string2, string, string5)) == null) continue;
            if (string3.equalsIgnoreCase("NULL")) {
                if (null != section.removeProperty(string4)) continue;
                logger.trace((Object)("No such property: " + string4));
                continue;
            }
            if (section == null) {
                section = new Section();
                this.sections.put(string5, section);
            }
            section.setProperty(string4, string3);
        }
    }

    private String getCleanPropertyName(String string, String string2, String string3) {
        String string4 = JwcProperties.prependPrefix(string2, string3) + ".";
        if (string.startsWith(string4)) {
            return string.substring(string4.length());
        }
        return null;
    }

    private String getSectionName(String string, String string2) {
        int n;
        if (string.startsWith(string2) && (n = string.indexOf(".", string2.length() + 1)) > 0) {
            return string.substring(string2.length() + 1, n);
        }
        return NO_PREFIX_SECTION;
    }

    private static final class Section {
        private final Map<String, String> properties = new HashMap<String, String>();

        public void setProperty(String string, String string2) {
            this.properties.put(string, string2);
        }

        public String getProperty(String string) {
            return this.properties.get(string);
        }

        public String removeProperty(String string) {
            return this.properties.remove(string);
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return this.properties.entrySet().iterator();
        }
    }
}

