/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.cldc;

import com.sun.jme.emulator.cldc.JwcProperties;
import com.sun.jme.toolkit.vm.Launcher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public final class JwcPropertiesConfigurator {
    private Launcher vm;
    private File defaultJwcPropertiesFile;
    private File updatedJwcPropertiesFile;
    private String runtimePropertiesPrefix;

    public void setVm(Launcher launcher) {
        this.vm = launcher;
    }

    public void setDefaultJwcPropertiesFile(File file) {
        this.defaultJwcPropertiesFile = file;
    }

    public void setUpdatedJwcPropertiesFile(File file) {
        this.updatedJwcPropertiesFile = file;
    }

    public void setRuntimePropertiesPrefix(String string) {
        this.runtimePropertiesPrefix = string;
    }

    public void start() throws IOException {
        JwcProperties jwcProperties = JwcPropertiesConfigurator.loadProperties(this.defaultJwcPropertiesFile);
        Properties properties = System.getProperties();
        jwcProperties.mergeProperties(properties, this.runtimePropertiesPrefix);
        JwcPropertiesConfigurator.saveProperties(this.updatedJwcPropertiesFile, jwcProperties);
        this.vm.appendArgument("-Xprefs:" + this.updatedJwcPropertiesFile.getAbsolutePath());
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JwcProperties loadProperties(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        JwcProperties jwcProperties = new JwcProperties();
        try {
            jwcProperties.load(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
        return jwcProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveProperties(File file, JwcProperties jwcProperties) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        try {
            jwcProperties.save(printWriter);
        }
        finally {
            printWriter.close();
        }
    }
}

