/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.appmanager.AppManagerException;
import com.sun.jme.toolkit.device.appmanager.InstallException;
import com.sun.jme.toolkit.device.appmanager.api.AppManager;
import com.sun.jme.toolkit.ueiproxy.CldcRunningAppTask;
import com.sun.jme.toolkit.ueiproxy.DeviceController;
import com.sun.jme.toolkit.ueiproxy.Encoder;
import com.sun.jme.toolkit.ueiproxy.ExceptionTranslator;
import com.sun.jme.toolkit.ueiproxy.RunOptions;
import com.sun.jme.toolkit.ueiproxy.ServerRunner;
import com.sun.jme.toolkit.ueiproxy.TaskManager;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.net.InetAddress;

public final class AppManagerHelper {
    private TaskManager taskManager;

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMIDletSuite(DeviceController deviceController, AppManager appManager, String string, boolean bl, String string2, RunOptions runOptions) throws UeiProxyException {
        ServerRunner serverRunner = new ServerRunner();
        String string3 = Encoder.encode(AppManagerHelper.startHttpServer(deviceController, string, serverRunner));
        System.out.println("Installing suite from: " + string3);
        try {
            CldcRunningAppTask cldcRunningAppTask = new CldcRunningAppTask(deviceController, appManager);
            try {
                int n = appManager.executeMIDletSuite(string3, true, string2, AppManagerHelper.constructRunFlags(runOptions));
                cldcRunningAppTask.setApplicationId(n);
                cldcRunningAppTask.setRunOptions(runOptions);
                this.taskManager.started(cldcRunningAppTask);
            }
            catch (InstallException installException) {
                cldcRunningAppTask.stop();
                throw AppManagerHelper.convertInstallException(string3, installException);
            }
            catch (AppManagerException appManagerException) {
                cldcRunningAppTask.stop();
                throw AppManagerHelper.convertAppManagerException(appManagerException);
            }
            catch (RuntimeException runtimeException) {
                cldcRunningAppTask.stop();
                throw new UeiProxyException("Failed to execute MIDlet suite!", runtimeException);
            }
        }
        finally {
            serverRunner.stopServer();
        }
    }

    public void runMIDletSuite(DeviceController deviceController, AppManager appManager, String string, String string2, RunOptions runOptions) throws UeiProxyException {
        CldcRunningAppTask cldcRunningAppTask = new CldcRunningAppTask(deviceController, appManager);
        try {
            try {
                int n = Integer.parseInt(string);
                appManager.runMIDletSuite(n, string2, AppManagerHelper.constructRunFlags(runOptions));
                cldcRunningAppTask.setApplicationId(n);
            }
            catch (NumberFormatException numberFormatException) {
                appManager.runMIDletSuite(string, string2, AppManagerHelper.constructRunFlags(runOptions));
            }
            cldcRunningAppTask.setRunOptions(runOptions);
            this.taskManager.started(cldcRunningAppTask);
        }
        catch (AppManagerException appManagerException) {
            cldcRunningAppTask.stop();
            throw AppManagerHelper.convertAppManagerException(appManagerException);
        }
        catch (RuntimeException runtimeException) {
            cldcRunningAppTask.stop();
            throw new UeiProxyException("Failed to run MIDlet suite!", runtimeException);
        }
    }

    public int installMIDletSuite(DeviceController deviceController, AppManager appManager, String string, boolean bl) throws UeiProxyException {
        ServerRunner serverRunner = new ServerRunner();
        String string2 = Encoder.encode(AppManagerHelper.startHttpServer(deviceController, string, serverRunner));
        System.out.println("Installing suite from: " + string2);
        try {
            int n = appManager.installMIDletSuite(string2, bl);
            return n;
        }
        catch (InstallException installException) {
            throw AppManagerHelper.convertInstallException(string2, installException);
        }
        catch (AppManagerException appManagerException) {
            throw AppManagerHelper.convertAppManagerException(appManagerException);
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to install MIDlet suite!", runtimeException);
        }
        finally {
            serverRunner.stopServer();
        }
    }

    public void removeMIDletSuite(AppManager appManager, String string) throws UeiProxyException {
        try {
            try {
                int n = Integer.parseInt(string);
                appManager.removeMIDletSuite(n);
            }
            catch (NumberFormatException numberFormatException) {
                appManager.removeMIDletSuite(string);
            }
        }
        catch (AppManagerException appManagerException) {
            throw AppManagerHelper.convertAppManagerException(appManagerException);
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to remove MIDlet suite!", runtimeException);
        }
    }

    public void launchAutotester(AppManager appManager, String string, String string2) throws UeiProxyException {
        try {
            appManager.launchAutotester(Encoder.encode(string), string2);
        }
        catch (InstallException installException) {
            throw AppManagerHelper.convertInstallException(string, installException);
        }
        catch (AppManagerException appManagerException) {
            throw AppManagerHelper.convertAppManagerException(appManagerException);
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to launch autotester!", runtimeException);
        }
    }

    private static UeiProxyException convertInstallException(String string, InstallException installException) {
        return new UeiProxyException("A problem occured during deploying application from " + string, new Exception(ExceptionTranslator.messageForInstallException(installException)));
    }

    private static UeiProxyException convertAppManagerException(AppManagerException appManagerException) {
        return new UeiProxyException("A problem occured during invoking Java ME Service", appManagerException);
    }

    private static String startHttpServer(DeviceController deviceController, String string, ServerRunner serverRunner) throws UeiProxyException {
        if (!string.startsWith("http")) {
            InetAddress inetAddress = deviceController.getDeviceHostAddress();
            return serverRunner.startServer(string, inetAddress);
        }
        return string;
    }

    private static int constructRunFlags(RunOptions runOptions) {
        int n = 0;
        if (runOptions.isDebug()) {
            n |= 1;
            if (runOptions.isSuspend()) {
                n |= 2;
            }
        }
        if (runOptions.isProfile()) {
            n |= 4;
        }
        return n;
    }
}

