/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.appmanager.api.AppEventListener;
import com.sun.jme.toolkit.device.appmanager.api.AppManager;
import com.sun.jme.toolkit.ueiproxy.DeviceController;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerListener;
import com.sun.jme.toolkit.ueiproxy.Task;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class CldcRunningAppTask
extends Task
implements AppEventListener,
DeviceControllerListener {
    private static final Logger LOGGER = Logger.getLogger(CldcRunningAppTask.class);
    private final AppManager applicationManager;
    private boolean unknownApplicationId;
    private boolean finished;
    private List<Integer> tmpStoppedAppIds;

    public CldcRunningAppTask(DeviceController deviceController, AppManager appManager) throws UeiProxyException {
        this.deviceController = deviceController;
        this.applicationManager = appManager;
        this.unknownApplicationId = true;
        this.tmpStoppedAppIds = new ArrayList<Integer>(0);
        deviceController.registerCallback("AppManager", AppEventListener.class, this, "addAppEventListener", "removeAppEventListener");
        deviceController.addListener(this);
        deviceController.showDeviceOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean bl;
        CldcRunningAppTask cldcRunningAppTask = this;
        synchronized (cldcRunningAppTask) {
            bl = !this.finished && !this.unknownApplicationId;
        }
        if (bl) {
            try {
                this.applicationManager.stopMIDletSuite(this.applicationId, null);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Failed to stop application " + this.applicationId + " on device " + this.deviceController.getDeviceId()), (Throwable)exception);
            }
        }
        this.finishAndNotify();
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationId(int n) {
        boolean bl;
        CldcRunningAppTask cldcRunningAppTask = this;
        synchronized (cldcRunningAppTask) {
            bl = this.tmpStoppedAppIds.contains(n);
            this.tmpStoppedAppIds = null;
            this.applicationId = n;
            this.unknownApplicationId = false;
        }
        if (bl) {
            this.finishAndNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAppEvent(int n, int n2) {
        if (n2 != 513) {
            return;
        }
        boolean bl = false;
        CldcRunningAppTask cldcRunningAppTask = this;
        synchronized (cldcRunningAppTask) {
            if (this.unknownApplicationId) {
                this.tmpStoppedAppIds.add(n);
            } else if (this.applicationId == n) {
                bl = true;
            }
        }
        if (bl) {
            this.finishAndNotify();
        }
    }

    @Override
    public void deviceDisconnected(DeviceController deviceController) {
        this.finishAndNotify();
    }

    @Override
    public void controllerStopped(DeviceController deviceController) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAndNotify() {
        boolean bl;
        CldcRunningAppTask cldcRunningAppTask = this;
        synchronized (cldcRunningAppTask) {
            bl = this.finished;
            this.finished = true;
        }
        if (!bl) {
            this.deviceController.hideDeviceOutput();
            this.deviceController.unregisterCallback("AppManager", this);
            this.deviceController.removeListener(this);
            this.notifyFinished();
        }
    }
}

