/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceState;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateManager;
import com.sun.jme.toolkit.deviceadapter.api.DeviceAdapter;
import com.sun.jme.toolkit.remoting.client.api.DeviceConnectionManager;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.jme.toolkit.ueiproxy.DeviceController;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerListener;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerConnector;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerListener;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class DeviceControllerManager
implements DeviceManagerListener,
DeviceControllerListener {
    private static final Logger LOGGER = Logger.getLogger(DeviceControllerManager.class);
    private final Map<Integer, DeviceController> deviceControllers = new HashMap<Integer, DeviceController>();
    private DeviceManagerConnector deviceManagerConnector;
    private DeviceConnectionManager deviceConnectionFactory;
    private boolean stopping;

    public void setDeviceManagerConnector(DeviceManagerConnector deviceManagerConnector) {
        this.deviceManagerConnector = deviceManagerConnector;
    }

    public void setDeviceConnectionFactory(DeviceConnectionManager deviceConnectionManager) {
        this.deviceConnectionFactory = deviceConnectionManager;
    }

    public void start() throws UeiProxyException {
        this.deviceManagerConnector.addDeviceManagerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.deviceManagerConnector.removeDeviceManagerListener((DeviceManagerListener)this);
        DeviceController[] deviceControllerArray = this;
        synchronized (this) {
            DeviceController[] deviceControllerArray2 = this.getCurrentControllers();
            this.stopping = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (DeviceController deviceController : deviceControllerArray2) {
                deviceController.stop();
            }
            return;
        }
    }

    public DeviceController getOrCreateDeviceController(String string, String[] stringArray) throws UeiProxyException {
        int n = this.deviceManagerConnector.getRegisteredDeviceId(string);
        return this.getOrCreateDeviceController(n, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceController getOrCreateDeviceController(int n, String[] stringArray) throws UeiProxyException {
        DeviceControllerManager deviceControllerManager = this;
        synchronized (deviceControllerManager) {
            DeviceController deviceController = this.deviceControllers.get(n);
            if (deviceController != null) {
                LOGGER.debug((Object)("Returning an existing device controller for device " + n));
                return deviceController;
            }
        }
        this.connectDevice(n, stringArray);
        return this.getOrCreateDeviceController(n);
    }

    public synchronized DeviceController getOrCreateDeviceController(int n) throws UeiProxyException {
        ObjectServerConnection objectServerConnection;
        DeviceController deviceController = this.deviceControllers.get(n);
        if (deviceController != null) {
            LOGGER.debug((Object)("Returning an existing device controller for device " + n));
            return deviceController;
        }
        this.verifyDeviceConnected(n);
        this.verifyNotStopping();
        try {
            objectServerConnection = this.deviceConnectionFactory.openDeviceConnection(n);
        }
        catch (Exception exception) {
            throw new UeiProxyException("Failed to open device connection to device " + n + "!", exception);
        }
        DeviceController deviceController2 = new DeviceController(n, objectServerConnection);
        this.deviceControllers.put(n, deviceController2);
        deviceController2.addListener(this);
        return deviceController2;
    }

    @Override
    public void deviceDisconnected(DeviceController deviceController) {
    }

    @Override
    public synchronized void controllerStopped(DeviceController deviceController) {
        this.deviceControllers.remove(deviceController.getDeviceId());
        LOGGER.debug((Object)("Controller for device " + deviceController.getDeviceId() + " removed from the list"));
    }

    private void connectDevice(int n, String[] stringArray) throws UeiProxyException {
        DeviceAdapter deviceAdapter = this.deviceManagerConnector.getDeviceAdapter(n);
        try {
            deviceAdapter.connect(n, stringArray);
        }
        catch (Exception exception) {
            throw new UeiProxyException("Failed to connect to device " + n + "!", exception);
        }
    }

    private void verifyDeviceConnected(int n) throws UeiProxyException {
        DeviceStateManager deviceStateManager = this.deviceManagerConnector.getDeviceStateManager();
        if (!deviceStateManager.getDeviceState(n).isConnected()) {
            throw new UeiProxyException("Device " + n + " is" + " not connected!");
        }
    }

    private void verifyNotStopping() throws UeiProxyException {
        if (this.stopping) {
            throw new UeiProxyException("Stopping in progress!");
        }
    }

    private DeviceController[] getCurrentControllers() {
        DeviceController[] deviceControllerArray = new DeviceController[this.deviceControllers.size()];
        return this.deviceControllers.values().toArray(deviceControllerArray);
    }

    @Override
    public void deviceRegistered(int n) {
    }

    @Override
    public void deviceUnregistered(int n) {
        this.notifyDeviceDisconnected(n);
    }

    @Override
    public void deviceStateChanged(int n, DeviceState deviceState, DeviceState deviceState2) {
        if (deviceState2.isConnected()) {
            return;
        }
        this.notifyDeviceDisconnected(n);
    }

    @Override
    public void managerDisconnected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeviceDisconnected(int n) {
        DeviceController deviceController;
        DeviceControllerManager deviceControllerManager = this;
        synchronized (deviceControllerManager) {
            deviceController = this.deviceControllers.get(n);
        }
        if (deviceController != null) {
            deviceController.notifyDeviceDisconnected();
        }
    }
}

