/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceManager;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistrationListener;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceState;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateListener;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateManager;
import com.sun.jme.toolkit.deviceRegistry.api.RegistrationData;
import com.sun.jme.toolkit.deviceadapter.api.DeviceAdapter;
import com.sun.jme.toolkit.deviceadapter.api.DeviceProperties;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnectionListener;
import com.sun.jme.toolkit.ueiproxy.DeviceManagerListener;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public final class DeviceManagerConnector
implements Runnable,
DeviceRegistrationListener,
DeviceStateListener,
ObjectServerConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(DeviceManagerConnector.class);
    private ObjectServerConnection deviceManagerConnection;
    private DeviceManager cachedDeviceManager;
    private DeviceStateManager cachedDeviceStateManager;
    private final Set<DeviceManagerListener> listeners = new HashSet<DeviceManagerListener>();
    private final List<Runnable> events = new LinkedList<Runnable>();
    private Thread notificationThread;
    private boolean stopNotificationThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws UeiProxyException {
        this.notificationThread = new Thread(this);
        this.notificationThread.start();
        try {
            this.registerCallback("DeviceManager", DeviceRegistrationListener.class, this, "addDeviceRegistrationListener", "removeDeviceRegistrationListener");
            this.registerCallback("DeviceRegistrationManager", DeviceStateListener.class, this, "addDeviceStateListener", "removeDeviceStateListener");
        }
        catch (UeiProxyException ueiProxyException) {
            this.unregisterCallback("DeviceManager", this);
            this.unregisterCallback("DeviceRegistrationManager", this);
            List<Runnable> list = this.events;
            synchronized (list) {
                this.stopNotificationThread = true;
                this.events.notifyAll();
            }
            throw ueiProxyException;
        }
        this.deviceManagerConnection.addConnectionListener((ObjectServerConnectionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.deviceManagerConnection.removeConnectionListener((ObjectServerConnectionListener)this);
        this.unregisterCallback("DeviceManager", this);
        this.unregisterCallback("DeviceRegistrationManager", this);
        List<Runnable> list = this.events;
        synchronized (list) {
            this.stopNotificationThread = true;
            this.events.notifyAll();
        }
        try {
            this.notificationThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setDeviceManagerConnection(ObjectServerConnection objectServerConnection) {
        this.deviceManagerConnection = objectServerConnection;
    }

    public String getDefaultDeviceName() throws UeiProxyException {
        return this.getDeviceRegistrationData(0).getName();
    }

    public DeviceProperties getDeviceProperties(int n) throws UeiProxyException {
        DeviceAdapter deviceAdapter = this.getDeviceAdapter(n);
        try {
            return deviceAdapter.getDeviceProperties(n);
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to get device properties for device " + n + "!", runtimeException);
        }
    }

    public int getDeviceId(String string) throws UeiProxyException {
        int n;
        try {
            n = this.getDeviceManager().lookupDeviceId(string);
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to get device id for \"" + string + "\"!", runtimeException);
        }
        return n;
    }

    public int getRegisteredDeviceId(String string) throws UeiProxyException {
        int n = this.getDeviceId(string);
        if (n == -1) {
            throw new UeiProxyException("Device \"" + string + "\" not" + " registered!");
        }
        return n;
    }

    public DeviceAdapter getDeviceAdapter(int n) throws UeiProxyException {
        String string = this.getDeviceRegistrationData(n).getAdapter();
        return this.getDeviceAdapter(string);
    }

    public DeviceAdapter getDeviceAdapter(String string) throws UeiProxyException {
        try {
            return (DeviceAdapter)this.deviceManagerConnection.findObject(DeviceAdapter.class, string);
        }
        catch (Exception exception) {
            throw new UeiProxyException("Failed to get reference to device adapter \"" + string + "\" from device manager!", exception);
        }
    }

    public synchronized DeviceManager getDeviceManager() throws UeiProxyException {
        if (this.cachedDeviceManager == null) {
            this.cachedDeviceManager = this.getObjectFromDeviceManager(DeviceManager.class, "DeviceManager");
        }
        return this.cachedDeviceManager;
    }

    public synchronized DeviceStateManager getDeviceStateManager() throws UeiProxyException {
        if (this.cachedDeviceStateManager == null) {
            this.cachedDeviceStateManager = this.getObjectFromDeviceManager(DeviceStateManager.class, "DeviceRegistrationManager");
        }
        return this.cachedDeviceStateManager;
    }

    public <T> T getObjectFromDeviceManager(Class<T> clazz, String string) throws UeiProxyException {
        Object object;
        try {
            object = this.deviceManagerConnection.findObject(clazz, string);
            LOGGER.debug((Object)("Got reference to " + string));
        }
        catch (Exception exception) {
            throw new UeiProxyException("Can't get reference to \"" + string + "\" from device manager!", exception);
        }
        return (T)object;
    }

    public <ListenerType> void registerCallback(String string, Class<ListenerType> clazz, ListenerType ListenerType, String string2, String string3) throws UeiProxyException {
        try {
            this.deviceManagerConnection.registerCallback(string, clazz, ListenerType, string2, string3);
        }
        catch (Exception exception) {
            throw new UeiProxyException("Failed to register \"" + string + "\" listener" + " of device manager!", exception);
        }
    }

    public void unregisterCallback(String string, Object object) {
        try {
            this.deviceManagerConnection.unregisterCallback(string, object);
        }
        catch (Exception exception) {
            LOGGER.debug((Object)("Exception while unregistering \"" + string + "\" listener of device manager!"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeviceManagerListener(DeviceManagerListener deviceManagerListener) {
        Set<DeviceManagerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(deviceManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeviceManagerListener(DeviceManagerListener deviceManagerListener) {
        Set<DeviceManagerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(deviceManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceRegistered(final int n) {
        List<Runnable> list = this.events;
        synchronized (list) {
            this.events.add(new Runnable(){

                @Override
                public void run() {
                    DeviceManagerConnector.this.forwardDeviceRegistered(n);
                }
            });
            this.events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceUnregistered(final int n) {
        List<Runnable> list = this.events;
        synchronized (list) {
            this.events.add(new Runnable(){

                @Override
                public void run() {
                    DeviceManagerConnector.this.forwardDeviceUnregistered(n);
                }
            });
            this.events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(final int n, final DeviceState deviceState, final DeviceState deviceState2) {
        List<Runnable> list = this.events;
        synchronized (list) {
            this.events.add(new Runnable(){

                @Override
                public void run() {
                    DeviceManagerConnector.this.forwardDeviceStateChanged(n, deviceState, deviceState2);
                }
            });
            this.events.notifyAll();
        }
    }

    public void openFailed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionLost() {
        Object object = this;
        synchronized (object) {
            this.cachedDeviceManager = null;
            this.cachedDeviceStateManager = null;
        }
        object = this.events;
        synchronized (object) {
            this.events.add(new Runnable(){

                @Override
                public void run() {
                    DeviceManagerConnector.this.forwardManagerDisconnected();
                }
            });
            this.events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                Runnable runnable;
                List<Runnable> list = this.events;
                synchronized (list) {
                    while (!this.stopNotificationThread && this.events.isEmpty()) {
                        this.events.wait();
                    }
                    if (this.stopNotificationThread) {
                        break;
                    }
                    runnable = this.events.remove(0);
                }
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private RegistrationData getDeviceRegistrationData(int n) throws UeiProxyException {
        try {
            return this.getDeviceManager().getDeviceRegistration(n);
        }
        catch (RuntimeException runtimeException) {
            throw new UeiProxyException("Failed to get registration data for device " + n + "!", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceManagerListener[] getCurrentListeners() {
        Set<DeviceManagerListener> set = this.listeners;
        synchronized (set) {
            DeviceManagerListener[] deviceManagerListenerArray = new DeviceManagerListener[this.listeners.size()];
            return this.listeners.toArray(deviceManagerListenerArray);
        }
    }

    private void forwardDeviceRegistered(int n) {
        DeviceManagerListener[] deviceManagerListenerArray;
        for (DeviceManagerListener deviceManagerListener : deviceManagerListenerArray = this.getCurrentListeners()) {
            try {
                deviceManagerListener.deviceRegistered(n);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error((Object)"Exception while forwarding device registered notification!", (Throwable)runtimeException);
            }
        }
    }

    private void forwardDeviceUnregistered(int n) {
        DeviceManagerListener[] deviceManagerListenerArray;
        for (DeviceManagerListener deviceManagerListener : deviceManagerListenerArray = this.getCurrentListeners()) {
            try {
                deviceManagerListener.deviceUnregistered(n);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error((Object)"Exception while forwarding device unregistered notification!", (Throwable)runtimeException);
            }
        }
    }

    private void forwardDeviceStateChanged(int n, DeviceState deviceState, DeviceState deviceState2) {
        DeviceManagerListener[] deviceManagerListenerArray;
        for (DeviceManagerListener deviceManagerListener : deviceManagerListenerArray = this.getCurrentListeners()) {
            try {
                deviceManagerListener.deviceStateChanged(n, deviceState, deviceState2);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error((Object)"Exception while forwarding device state changed notification!", (Throwable)runtimeException);
            }
        }
    }

    private void forwardManagerDisconnected() {
        DeviceManagerListener[] deviceManagerListenerArray;
        for (DeviceManagerListener deviceManagerListener : deviceManagerListenerArray = this.getCurrentListeners()) {
            try {
                deviceManagerListener.managerDisconnected();
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error((Object)"Exception while forwarding manager disconnected notification!", (Throwable)runtimeException);
            }
        }
    }
}

