/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.appmanager.InstallException;

final class ExceptionTranslator {
    public static final int JAD_SERVER_NOT_FOUND = 1;
    public static final int JAD_NOT_FOUND = 2;
    public static final int MISSING_PROVIDER_CERT = 4;
    public static final int CORRUPT_PROVIDER_CERT = 5;
    public static final int UNKNOWN_CA = 6;
    public static final int INVALID_PROVIDER_CERT = 7;
    public static final int CORRUPT_SIGNATURE = 8;
    public static final int INVALID_SIGNATURE = 9;
    public static final int UNSUPPORTED_CERT = 10;
    public static final int EXPIRED_PROVIDER_CERT = 11;
    public static final int EXPIRED_CA_KEY = 12;
    public static final int MISSING_SUITE_NAME = 13;
    public static final int MISSING_VENDOR = 14;
    public static final int MISSING_VERSION = 15;
    public static final int INVALID_VERSION = 16;
    public static final int OLD_VERSION = 17;
    public static final int MISSING_JAR_URL = 18;
    public static final int JAR_SERVER_NOT_FOUND = 19;
    public static final int JAR_NOT_FOUND = 20;
    public static final int MISSING_JAR_SIZE = 21;
    public static final int SUITE_NAME_MISMATCH = 25;
    public static final int VERSION_MISMATCH = 26;
    public static final int VENDOR_MISMATCH = 27;
    public static final int INVALID_KEY = 28;
    public static final int INVALID_VALUE = 29;
    public static final int INSUFFICIENT_STORAGE = 30;
    public static final int JAR_SIZE_MISMATCH = 31;
    public static final int NEW_VERSION = 32;
    public static final int UNAUTHORIZED = 33;
    public static final int JAD_MOVED = 34;
    public static final int CANNOT_AUTH = 35;
    public static final int CORRUPT_JAR = 36;
    public static final int INVALID_JAD_TYPE = 37;
    public static final int INVALID_JAR_TYPE = 38;
    public static final int ALREADY_INSTALLED = 39;
    public static final int DEVICE_INCOMPATIBLE = 40;
    public static final int MISSING_CONFIGURATION = 41;
    public static final int MISSING_PROFILE = 42;
    public static final int INVALID_JAD_URL = 43;
    public static final int INVALID_JAR_URL = 44;
    public static final int PUSH_DUP_FAILURE = 45;
    public static final int PUSH_FORMAT_FAILURE = 46;
    public static final int PUSH_PROTO_FAILURE = 47;
    public static final int PUSH_CLASS_FAILURE = 48;
    public static final int AUTHORIZATION_FAILURE = 49;
    public static final int ATTRIBUTE_MISMATCH = 50;
    public static final int PROXY_AUTH = 51;
    public static final int TRUSTED_OVERWRITE_FAILURE = 52;
    public static final int TOO_MANY_PROPS = 53;
    public static final int INVALID_CONTENT_HANDLER = 54;
    public static final int CONTENT_HANDLER_CONFLICT = 55;
    public static final int JAR_CLASSES_VERIFICATION_FAILED = 56;
    public static final int UNSUPPORTED_PAYMENT_INFO = 57;
    public static final int INVALID_PAYMENT_INFO = 58;
    public static final int UNTRUSTED_PAYMENT_SUITE = 59;
    public static final int CA_DISABLED = 60;
    public static final int UNSUPPORTED_CHAR_ENCODING = 61;
    public static final int REVOKED_CERT = 62;
    public static final int UNKNOWN_CERT_STATUS = 63;
    public static final int IO_ERROR = 500;
    public static final int SECURITY_ERROR = 501;
    public static final int MIDLET_LOCKED_ERROR = 502;
    public static final int INSTALLATION_CANCELED = 503;
    public static final int UNKNOWN_ERROR = 1000;

    private ExceptionTranslator() {
    }

    static String messageForInstallException(InstallException installException) {
        switch (installException.getReason()) {
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 41: 
            case 42: {
                return "Application cannot be installed because critical information is missing from the application file (.jad).";
            }
            case 25: 
            case 26: 
            case 27: {
                return "Application cannot be installed because critical  information between the website and the application file does not match.";
            }
            case 50: {
                return "Application cannot be installed because the value for " + installException.getExtraData() + " in the trusted JAR manifest did not " + "match the one in the JAD";
            }
            case 5: {
                return "Application cannot be installed because the application files cannot be verified. Contact your application provider to correct this situation.";
            }
            case 6: {
                return "The content provider certificate issuer " + installException.getExtraData() + " is unknown.";
            }
            case 7: {
                return "The signature of the content provider certificate is invalid.";
            }
            case 8: {
                return "The JAR signature cannot be decoded.";
            }
            case 9: {
                return "The signature of the JAR is invalid.";
            }
            case 10: {
                return "The content provider certificate is not a supported version.";
            }
            case 11: {
                return "The content provider certificate is expired.";
            }
            case 12: {
                return "The public key of " + installException.getExtraData() + " has expired.";
            }
            case 31: {
                return "The Jar downloaded was not the size in the JAD";
            }
            case 17: {
                return "The application is an older version of one that is already installed";
            }
            case 32: {
                return "The application is an newer version of one that is already installed";
            }
            case 43: {
                return "The JAD URL is invalid";
            }
            case 1: {
                return "JAD server not found";
            }
            case 2: {
                return "JAD not found";
            }
            case 44: {
                return "The JAR URL in the JAD is invalid: " + installException.getExtraData();
            }
            case 19: {
                return "JAR server not found: " + installException.getExtraData();
            }
            case 20: {
                return "JAR not found: " + installException.getExtraData();
            }
            case 36: {
                return "Corrupt JAR, error while reading: " + installException.getExtraData();
            }
            case 38: {
                if (installException.getExtraData() != null) {
                    return "JAR did not have the correct media type, it had " + installException.getExtraData();
                }
                return "The server did not have a resource with an acceptable media type for the JAR URL. (code 406)";
            }
            case 37: {
                if (installException.getExtraData() != null) {
                    String string = installException.getExtraData();
                    if (string.length() == 0) {
                        return "JAD did not have a media type";
                    }
                    return "JAD did not have the correct media type, it had " + string;
                }
                return "The server did not have a resource with an acceptable media type for the JAD URL. (code 406)";
            }
            case 28: {
                return "The attribute key [" + installException.getExtraData() + "] is not in the proper format";
            }
            case 29: {
                return "The value for attribute " + installException.getExtraData() + " is not in the proper format";
            }
            case 30: {
                return "There is insufficient storage to install this suite";
            }
            case 33: {
                return "Authentication required or failed";
            }
            case 34: {
                return "The JAD to be installed is for an existing suite, but not from the same domain as the existing one: " + installException.getExtraData();
            }
            case 35: {
                return "Cannot authenticate with the server, unsupported scheme";
            }
            case 40: {
                return "Either the configuration or profile is not supported.";
            }
            case 39: {
                return "The JAD matches a version of a suite already installed.";
            }
            case 49: {
                return "The suite is not authorized for " + installException.getExtraData();
            }
            case 45: {
                return "The suite is in conflict with another application listening for network data on " + installException.getExtraData();
            }
            case 46: {
                return "Push attribute in incorrectly formated: " + installException.getExtraData();
            }
            case 47: {
                return "Connection in push attribute is not supported: " + installException.getExtraData();
            }
            case 48: {
                return "The class in push attribute not in a MIDlet-<n> attribute: " + installException.getExtraData();
            }
            case 52: {
                return "Cannot update a trusted suite with an untrusted version";
            }
            case 54: {
                return "Content handler attribute(s) incorrectly formatted: " + installException.getExtraData();
            }
            case 55: {
                return "Content handler would conflict with another handler: " + installException.getExtraData();
            }
            case 60: {
                return "The application can't be authorized because " + installException.getExtraData() + " is disabled.";
            }
            case 61: {
                return "Unsupported character encoding: " + installException.getExtraData();
            }
            case 500: {
                return "I/O error: " + installException.getExtraData();
            }
            case 501: {
                return "Security error: " + installException.getExtraData();
            }
            case 502: {
                return "MIDlet suite is already running.";
            }
            case 503: {
                return "Installation was canceled.";
            }
            case 1000: {
                return "Uknown error: " + installException.getExtraData();
            }
        }
        return installException.getMessage();
    }
}

