/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc.launcher;

import com.sun.kvem.cdc.launcher.Application;
import com.sun.kvem.cdc.launcher.CancelException;
import com.sun.kvem.cdc.launcher.DebugPort;
import com.sun.kvem.environment.DevicePropertyManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AppLauncher
extends JFrame {
    private static final DevicePropertyManager devices = new DevicePropertyManager();
    private static AppLauncher launcher;
    private JList appList;
    private JList deviceList;
    private Action runAction;
    private Action debugAction;

    public static void main(String[] stringArray) {
        launcher = new AppLauncher();
        launcher.createUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = launcher.getSize();
        launcher.setLocation((dimension.width - dimension2.width) / 3, (dimension.height - dimension2.height) / 3);
        launcher.setVisible(true);
    }

    public AppLauncher() {
        super("CDC Application Launcher");
    }

    private void createUI() {
        this.setDefaultCloseOperation(3);
        Box box = Box.createHorizontalBox();
        box.add(this.createAppPanel());
        box.add(this.createDevicePanel());
        this.getContentPane().add(box);
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.setButtonEnablement();
        this.pack();
        DoubleClickListener doubleClickListener = new DoubleClickListener();
        this.appList.addMouseListener(doubleClickListener);
        this.deviceList.addMouseListener(doubleClickListener);
    }

    private Component createAppPanel() {
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Select Application"));
        this.appList = new JList<Application>(Application.getAllApps());
        this.appList.setSelectionMode(0);
        this.appList.addListSelectionListener(new AppSelectionListener());
        this.appList.addMouseListener(new MouseAdapter(){});
        JScrollPane jScrollPane = new JScrollPane(this.appList);
        box.add(jScrollPane);
        return box;
    }

    private Component createDevicePanel() {
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Select Device"));
        this.deviceList = new JList();
        this.deviceList.setSelectionMode(0);
        this.deviceList.addListSelectionListener(new DevicesSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.deviceList);
        box.add(jScrollPane);
        return box;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        this.runAction = new RunAction();
        this.debugAction = new DebugAction();
        jPanel.add(new JButton(this.runAction));
        return jPanel;
    }

    private void setButtonEnablement() {
        this.runAction.setEnabled(this.appList.getSelectedIndex() != -1 && this.deviceList.getSelectedIndex() != -1);
        this.debugAction.setEnabled(this.appList.getSelectedIndex() != -1 && this.deviceList.getSelectedIndex() != -1);
    }

    private void setupDeviceList() {
        DefaultListModel defaultListModel = new DefaultListModel();
        if (this.appList.getSelectedIndex() == -1) {
            this.deviceList.setListData(devices.getDeviceList());
        } else {
            Application application = (Application)this.appList.getSelectedValue();
            if (application.getDeviceList() == null) {
                this.deviceList.setListData(devices.getDeviceList());
            } else {
                this.deviceList.setListData(application.getDeviceList());
            }
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            JList jList;
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = (jList = (JList)mouseEvent.getSource()).locationToIndex(point = mouseEvent.getPoint())) >= 0 && jList.getCellBounds(n, n).contains(point)) {
                AppLauncher.this.runAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, ""));
            }
        }
    }

    class DevicesSelectionListener
    implements ListSelectionListener {
        DevicesSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                AppLauncher.this.setButtonEnablement();
            }
        }
    }

    class AppSelectionListener
    implements ListSelectionListener {
        AppSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                String string = (String)AppLauncher.this.deviceList.getSelectedValue();
                AppLauncher.this.setupDeviceList();
                AppLauncher.this.deviceList.setSelectedValue(string, true);
                AppLauncher.this.setButtonEnablement();
            }
        }
    }

    class DebugAction
    extends AbstractAction {
        public DebugAction() {
            this.putValue("Name", "Debug");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DebugPort debugPort = new DebugPort(launcher);
            try {
                int n = debugPort.getPortValue(5050);
                Application application = (Application)AppLauncher.this.appList.getSelectedValue();
                application.debug((String)AppLauncher.this.deviceList.getSelectedValue(), n);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("Name", "Run");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Application application = (Application)AppLauncher.this.appList.getSelectedValue();
            application.run((String)AppLauncher.this.deviceList.getSelectedValue());
        }
    }
}

