/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc.launcher;

import com.sun.kvem.environment.PropertiesFile;
import com.sun.kvem.environment.StreamCopier;
import com.sun.kvem.environment.ToolkitDirs;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

class Application {
    private static ArrayList apps;
    private static final String APP_PROPERTY = "App-";
    private static final String APP_CLASSPATH = "Classpath-";
    private static final String APP_DEVICES = "Devices-";
    private static final String DELIMETER = ",";
    private String name;
    private String mainClass;
    private String classpath;
    private String[] devices;

    public static Application[] getAllApps() {
        if (apps == null) {
            Application.initApps();
        }
        return apps.toArray(new Application[0]);
    }

    private static void initApps() {
        apps = new ArrayList();
        try {
            PropertiesFile propertiesFile = new PropertiesFile(new File(ToolkitDirs.LIB, "apps.properties"));
            int n = 1;
            while (propertiesFile.getProperty(APP_PROPERTY + n) != null) {
                apps.add(new Application(propertiesFile.getProperty(APP_PROPERTY + n), propertiesFile.getProperty("App-Classpath-" + n), propertiesFile.getProperty("App-Devices-" + n)));
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    Application(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIMETER);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            if (new File(string4).isAbsolute()) {
                if (this.classpath == null) {
                    this.classpath = string4;
                    continue;
                }
                this.classpath = string2 + File.pathSeparator + string4;
                continue;
            }
            try {
                string4 = new File(ToolkitDirs.HOME + string4).getCanonicalPath();
                if (this.classpath == null) {
                    this.classpath = string4;
                    continue;
                }
                this.classpath = this.classpath + File.pathSeparator + string4;
            }
            catch (IOException iOException) {
                this.classpath = this.classpath == null ? string4 : this.classpath + File.pathSeparator + ToolkitDirs.HOME + string4;
                iOException.printStackTrace();
            }
        }
        stringTokenizer = new StringTokenizer(string, DELIMETER);
        this.name = stringTokenizer.nextToken().trim();
        this.mainClass = stringTokenizer.nextToken().trim();
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, DELIMETER);
            this.devices = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < this.devices.length; ++i) {
                this.devices[i] = stringTokenizer.nextToken();
            }
        }
    }

    public void run(String string) {
        String[] stringArray = new String[]{System.getProperty("java.home") + File.separator + "bin\\java", "-classpath", ToolkitDirs.LIB + "toolkit.jar", "com.sun.kvem.cdc.Main", "-Xdevice:" + string, "-classpath", this.classpath, this.mainClass, "0"};
        this.execute(stringArray);
    }

    public void debug(String string, int n) {
        String[] stringArray = new String[]{System.getProperty("java.home") + File.separator + "bin\\java", "-classpath", ToolkitDirs.LIB + "toolkit.jar", "com.sun.kvem.cdc.Main", "-Xdevice:" + string, "-Xdebug", "-Xrunjdwp:transport=dt_socket,server=y,address=" + n + ",suspend=y", "-classpath", this.classpath, this.mainClass, "0"};
        this.execute(stringArray);
    }

    public String[] getDeviceList() {
        return this.devices;
    }

    public String toString() {
        return this.name;
    }

    private void execute(String[] stringArray) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            new Thread((Runnable)new StreamCopier(process.getErrorStream(), (OutputStream)System.err)).start();
            new Thread((Runnable)new StreamCopier(process.getInputStream(), (OutputStream)System.err)).start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

