/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cdc.launcher;

import com.sun.kvem.cdc.launcher.CancelException;
import com.sun.kvem.util.ActionReflector;
import com.sun.kvem.util.StateCondition;
import com.sun.kvem.util.StateController;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DebugPort {
    private final JDialog dialog;
    private final JTextField portInput = new JTextField(6);
    private int portValue;

    public DebugPort(JFrame jFrame) {
        this.dialog = new JDialog((Frame)jFrame, true);
        String string = ToolkitResources.getString((String)"DEBUG_PORT_TITLE");
        String string2 = ToolkitResources.getString((String)"DEBUG_PORT_LABEL");
        this.dialog.setTitle(string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setLabelFor(this.portInput);
        Box box = new Box(0);
        box.add(jLabel);
        box.add(Box.createGlue());
        box.add(Box.createHorizontalStrut(5));
        box.add(this.portInput);
        this.dialog.getContentPane().add(box);
        String string3 = ToolkitResources.getString((String)"DEBUG");
        String string4 = ToolkitResources.getString((String)"CANCEL");
        JButton jButton = new JButton(string3);
        jButton.setToolTipText(ToolkitResources.getString((String)"DEBUG_HELP"));
        jButton.setMnemonic(ToolkitResources.getString((String)"DEBUG_SHORTCUT").charAt(0));
        JButton jButton2 = new JButton(string4);
        jButton2.setToolTipText(ToolkitResources.getString((String)"CANCEL_HELP"));
        jButton2.setMnemonic(ToolkitResources.getString((String)"CANCEL_SHORTCUT").charAt(0));
        jButton.setActionCommand("ok");
        jButton2.setActionCommand("cancel");
        jButton.setEnabled(false);
        StateCondition stateCondition = new StateCondition(){

            public boolean enable(Component component, DocumentEvent documentEvent) {
                String string = DebugPort.this.portInput.getText();
                try {
                    int n = Integer.parseInt(string);
                    return n >= 1024 && n < 65536;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
        this.portInput.getDocument().addDocumentListener((DocumentListener)new StateController((Component)jButton, stateCondition));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.dialog.getContentPane().add("South", jPanel);
        ActionReflector actionReflector = new ActionReflector((Object)this);
        jButton.addActionListener((ActionListener)actionReflector);
        jButton2.addActionListener((ActionListener)actionReflector);
        this.dialog.pack();
        Rectangle rectangle = jFrame.getBounds();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Dimension dimension = this.dialog.getSize();
        this.dialog.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
    }

    public void ok() {
        try {
            this.portValue = Integer.parseInt(this.portInput.getText());
            this.dialog.setVisible(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void cancel() {
        this.portValue = -1;
        this.dialog.setVisible(false);
    }

    public int getPortValue(int n) throws CancelException {
        this.portValue = -1;
        this.portInput.setText(String.valueOf(n));
        this.dialog.setVisible(true);
        if (this.portValue == -1) {
            throw new CancelException();
        }
        return this.portValue;
    }
}

