/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.environment;

import com.sun.kvem.environment.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;

public class KeepAliveConnection {
    private static final Debug debug = Debug.create(KeepAliveConnection.class);
    private int port;
    private boolean initialized = false;
    private Runnable callback = null;
    private int delay;
    protected List<String> arguments;
    public static final int DEFAULT_POLLING_DELAY = 2500;
    public static final Runnable CALLBACK_EXIT = new Runnable(){

        @Override
        public void run() {
            System.exit(0);
        }
    };

    public void setArguments(List<String> list) {
        this.arguments = list;
    }

    public void create() {
        String[] stringArray = new String[this.arguments.size()];
        this.processArgv(this.arguments.toArray(stringArray));
        this.setCallback(CALLBACK_EXIT);
        this.run();
        if (this.initialized) {
            this.arguments.remove(this.arguments.size() - 1);
        }
    }

    public KeepAliveConnection() {
        this(2500);
    }

    public KeepAliveConnection(int n) {
        this.delay = n;
        debug.println(2, "Created a KeepAliveConnection, polling every {0} ms", n);
    }

    public String[] processArgv(String[] stringArray) {
        debug.println(2, "Processing arguments: {0}", (Object)stringArray);
        if (stringArray.length > 0) {
            this.port = Integer.parseInt(stringArray[stringArray.length - 1]);
            debug.println(2, "Using port {0}", this.port);
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            this.initialized = true;
            return stringArray2;
        }
        return stringArray;
    }

    public void setCallback(Runnable runnable) {
        this.callback = runnable;
    }

    public void run() {
        if (!this.initialized) {
            throw new IllegalStateException("KeepAliveConnection not initialized");
        }
        if (this.port == 0) {
            return;
        }
        new Thread((Runnable)new Communicator(), "Keep-alive Connection").start();
    }

    private class Communicator
    implements Runnable {
        private Communicator() {
        }

        @Override
        public void run() {
            try {
                try {
                    Thread.sleep(KeepAliveConnection.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                InetAddress inetAddress = InetAddress.getLocalHost();
                debug.println(1, "Opening connection on port {0}", KeepAliveConnection.this.port);
                Socket socket = new Socket(inetAddress, KeepAliveConnection.this.port);
                debug.println(1, "Established connection");
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                while (true) {
                    debug.println(4, "Checking connection...");
                    dataOutputStream.writeInt(1);
                    dataInputStream.readInt();
                    debug.println(4, "Connection OK");
                    try {
                        Thread.sleep(KeepAliveConnection.this.delay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (SocketException socketException) {
                debug.println(1, "Connection broken");
            }
            catch (IOException iOException) {
                debug.exception(4, (Throwable)iOException);
            }
            if (KeepAliveConnection.this.callback != null) {
                debug.println(1, "Running callback");
                KeepAliveConnection.this.callback.run();
            } else {
                debug.println(1, "No callback to run");
            }
        }
    }
}

