/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.traynotifications;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceManager;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistrationListener;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceState;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateListener;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceStateManager;
import com.sun.jme.toolkit.tray.TrayIconManager;

public class DeviceRegistrationNotifier {
    private String msgAvailable;
    private String msgUnavailable;
    private String msgRegistered;
    private String msgUnregistered;
    private TrayIconManager trayManager;
    private DeviceManager deviceManager;
    private DeviceStateManager deviceStateManager;
    private NotificationListener listener = new NotificationListener();

    public void setTrayIconManager(TrayIconManager trayIconManager) {
        this.trayManager = trayIconManager;
    }

    public void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public void setDeviceStateManager(DeviceStateManager deviceStateManager) {
        this.deviceStateManager = deviceStateManager;
    }

    public void setRegisterMessage(String string) {
        this.msgRegistered = string;
    }

    public void setUnregisterMessage(String string) {
        this.msgUnregistered = string;
    }

    public void setUnavailableMessage(String string) {
        this.msgUnavailable = string;
    }

    public void setAvailableMessage(String string) {
        this.msgAvailable = string;
    }

    public void start() {
        this.deviceManager.addDeviceRegistrationListener((DeviceRegistrationListener)this.listener);
        this.deviceStateManager.addDeviceStateListener((DeviceStateListener)this.listener);
    }

    public void stop() {
        this.deviceManager.removeDeviceRegistrationListener((DeviceRegistrationListener)this.listener);
        this.deviceStateManager.addDeviceStateListener((DeviceStateListener)this.listener);
    }

    private class NotificationListener
    implements DeviceRegistrationListener,
    DeviceStateListener {
        private NotificationListener() {
        }

        private String getDeviceStateNotificationMessage(DeviceState deviceState, DeviceState deviceState2) {
            if (!deviceState.isAvailable() && deviceState2.isAvailable()) {
                return DeviceRegistrationNotifier.this.msgAvailable;
            }
            if (deviceState.isAvailable() && !deviceState2.isAvailable()) {
                return DeviceRegistrationNotifier.this.msgUnavailable;
            }
            return null;
        }

        public void deviceRegistered(int n) {
            DeviceRegistrationNotifier.this.trayManager.showMessage(DeviceRegistrationNotifier.this.deviceManager.getDeviceRegistration(n).getName(), DeviceRegistrationNotifier.this.msgRegistered);
        }

        public void deviceUnregistered(int n) {
            DeviceRegistrationNotifier.this.trayManager.showMessage(DeviceRegistrationNotifier.this.deviceManager.getDeviceRegistration(n).getName(), DeviceRegistrationNotifier.this.msgUnregistered);
        }

        public void stateChanged(int n, DeviceState deviceState, DeviceState deviceState2) {
            String string = this.getDeviceStateNotificationMessage(deviceState, deviceState2);
            if (string != null) {
                DeviceRegistrationNotifier.this.trayManager.showMessage(DeviceRegistrationNotifier.this.deviceManager.getDeviceRegistration(n).getName(), string);
            }
        }
    }
}

