/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.ITimeoutableConnection;
import com.sun.spot.peripheral.TimeoutException;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.util.IEEEAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

public class BasestationManager {
    public static final byte CMD_DISCOVER = 0;

    public static void main(String[] strings) throws IOException {
        boolean testOnly = strings.length > 0 && strings[0].equalsIgnoreCase("TEST");
        boolean dontCreateProxyMac_ForTesting = strings.length > 0 && strings[0].equalsIgnoreCase("SINGLEMAC");
        new BasestationManager().start(testOnly, dontCreateProxyMac_ForTesting);
    }

    public void start(boolean testOnly, boolean dontCreateProxyMac_ForTesting) throws IOException {
        System.setProperty("spot.mesh.management.enable", "true");
        if (!dontCreateProxyMac_ForTesting) {
            System.setProperty("spot.basestation.manager", "true");
        }
        System.setProperty("spot.basestation.sharing", "true");
        if (testOnly) {
            return;
        }
        String serialPort = System.getProperty("SERIAL_PORT");
        System.out.println("Serial port=" + serialPort);
        System.out.println("Socket MAC address=" + IEEEAddress.toDottedHex((long)RadioFactory.getSocketMAC().mlmeGet(368)));
        System.out.println("Basestation address=" + IEEEAddress.toDottedHex((long)RadioFactory.getI802_15_4_MAC().mlmeGet(368)));
        IRadioPolicyManager rpm = RadioFactory.getRadioPolicyManager();
        String val = System.getProperty("remote.transmit.power");
        if (val != null && val.trim().length() > 0) {
            rpm.setOutputPower(Integer.parseInt(val));
        }
        if ((val = System.getProperty("remote.channel")) != null && val.trim().length() > 0) {
            rpm.setChannelNumber(Integer.parseInt(val));
        }
        if ((val = System.getProperty("remote.pan.id")) != null && val.trim().length() > 0) {
            rpm.setPanId((short)Integer.parseInt(val));
        }
        int channelNumber = RadioFactory.getRadioPolicyManager().getChannelNumber();
        System.out.println("Radio channel=" + channelNumber);
        short panId = RadioFactory.getRadioPolicyManager().getPanId();
        System.out.println("PAN Id=" + panId);
        int power = RadioFactory.getRadioPolicyManager().getOutputPower();
        System.out.println("Radio transmit power=" + power);
        System.out.println("Opening connections");
        DatagramConnection serverConn = (DatagramConnection)Connector.open((String)"radiogram://:14");
        Datagram rxDG = serverConn.newDatagram(serverConn.getMaximumLength());
        Datagram txDG = serverConn.newDatagram(serverConn.getMaximumLength());
        System.out.println("Entering server loop");
        while (true) {
            try {
                while (true) {
                    serverConn.receive(rxDG);
                    if (rxDG.readByte() != 0) continue;
                    String requiredHost = rxDG.readUTF();
                    String requiredPort = rxDG.readUTF();
                    System.out.println("Got discover request for host: " + requiredHost + " and port: " + (requiredPort.equals("") ? "<any>" : requiredPort));
                    if (requiredHost.equals(InetAddress.getLocalHost().getHostAddress()) && (requiredPort.equals("") || requiredPort.equalsIgnoreCase(serialPort))) {
                        System.out.println("Responding...");
                        txDG.reset();
                        txDG.writeUTF(System.getProperty("IEEE_ADDRESS"));
                        txDG.writeInt(channelNumber);
                        txDG.writeShort((int)panId);
                        txDG.writeUTF(serialPort);
                        txDG.setAddress(rxDG);
                        serverConn.send(txDG);
                        continue;
                    }
                    System.out.println("Ignoring request");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static DiscoverResult[] discover() throws IOException {
        return BasestationManager.discover(null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscoverResult[] discover(String requiredHostIP, String requiredCommsPort, boolean stopAfterFirstReply) throws IOException {
        if (requiredHostIP == null) {
            requiredHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        if (requiredCommsPort == null) {
            requiredCommsPort = "";
        }
        Vector<DiscoverResult> results = new Vector<DiscoverResult>();
        DatagramConnection txConn = (DatagramConnection)Connector.open((String)"radiogram://broadcast:14");
        DatagramConnection rxConn = (DatagramConnection)Connector.open((String)"radiogram://:14");
        try {
            Datagram txDG = txConn.newDatagram(txConn.getMaximumLength());
            ((ITimeoutableConnection)rxConn).setTimeout(1000L);
            txDG.write(0);
            txDG.writeUTF(requiredHostIP);
            txDG.writeUTF(requiredCommsPort);
            txConn.send(txDG);
            Datagram rxDG = rxConn.newDatagram(rxConn.getMaximumLength());
            while (!stopAfterFirstReply || results.isEmpty()) {
                try {
                    rxConn.receive(rxDG);
                    results.add(new DiscoverResult(new IEEEAddress(rxDG.readUTF()), rxDG.readInt(), rxDG.readShort(), rxDG.readUTF()));
                }
                catch (TimeoutException e) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            txConn.close();
            rxConn.close();
        }
        return results.toArray(new DiscoverResult[results.size()]);
    }

    public static class DiscoverResult {
        private final int channel;
        private final short panId;
        private final String port;
        private final IEEEAddress address;

        public int getChannel() {
            return this.channel;
        }

        public short getPanId() {
            return this.panId;
        }

        public String getPort() {
            return this.port;
        }

        public IEEEAddress getAddress() {
            return this.address;
        }

        private DiscoverResult(IEEEAddress address, int channel, short panId, String port) {
            this.channel = channel;
            this.panId = panId;
            this.port = port;
            this.address = address;
        }
    }
}

