/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.radio.ISocketMacBroadcastChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

class BroadcastChannel
implements ISocketMacBroadcastChannel {
    private static final String MULTICAST_ADDRESS = "224.0.0.19";
    private int destinationPort;
    private MulticastSocket socket;

    public BroadcastChannel(int destinationPort) {
        this.destinationPort = destinationPort;
        try {
            this.socket = new MulticastSocket(destinationPort);
            InetAddress address = InetAddress.getByName(MULTICAST_ADDRESS);
            this.socket.joinGroup(address);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void broadcast(byte[] byteArray) throws IOException {
        DatagramSocket sendSocket = new DatagramSocket();
        InetAddress group = InetAddress.getByName(MULTICAST_ADDRESS);
        DatagramPacket packet = new DatagramPacket(byteArray, byteArray.length, group, this.destinationPort);
        sendSocket.send(packet);
        sendSocket.close();
    }

    public void receive(DatagramPacket datagram) throws IOException {
        this.socket.receive(datagram);
    }

    public void close() {
        this.socket.close();
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }
}

