/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

class HostSerialPipe {
    private SerialPort serialPort;
    private BufferedInputStream in;
    private OutputStream out;
    private static final byte MAGIC_BYTE = -34;

    HostSerialPipe() {
    }

    public void receive(byte[] buffer) throws IOException {
        int length = 0;
        while (length == 0) {
            while (this.readByte() != -34) {
            }
            length = this.readAByte();
            if (length == 0) {
                System.out.println("[HostSerialPipe] zero-length payload skipped");
                continue;
            }
            for (int offset = 0; offset < length; offset += this.readBytes(buffer, offset, length - offset)) {
            }
        }
    }

    private int readAByte() throws IOException {
        int c = -1;
        while (c < 0) {
            c = this.in.read();
        }
        return c;
    }

    private byte readByte() throws IOException {
        int c = -1;
        while (c < 0) {
            c = this.in.read();
        }
        return (byte)c;
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        int c = -1;
        while (c < 0) {
            c = this.in.read(b, off, len);
        }
        return c;
    }

    public synchronized void send(byte[] payload) throws IOException {
        byte[] data = new byte[payload.length + 2];
        System.arraycopy(payload, 0, data, 2, payload.length);
        data[0] = -34;
        if ((byte)payload.length == -34) {
            System.out.println("Sending a packet of length 0xDE");
        }
        data[1] = (byte)payload.length;
        this.out.write(data);
    }

    public void initComms(String portName) throws IOException {
        CommPortIdentifier nextPortId;
        Enumeration portList;
        CommPortIdentifier portId = null;
        int retryCount = 5;
        while (portId == null && retryCount > 0) {
            portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                nextPortId = (CommPortIdentifier)portList.nextElement();
                if (nextPortId.getPortType() != 1 || !nextPortId.getName().equalsIgnoreCase(portName)) continue;
                portId = nextPortId;
                break;
            }
            if (portId != null) continue;
            --retryCount;
            System.out.println("Port " + portName + " unavailable... retrying...");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {}
        }
        if (portId == null) {
            System.out.print("Available ports: ");
            portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                nextPortId = (CommPortIdentifier)portList.nextElement();
                System.out.print(nextPortId.getName() + " ");
            }
            System.out.println();
            throw new IllegalArgumentException(portName + " not found");
        }
        try {
            this.serialPort = (SerialPort)portId.open("Flasher", 2000);
        }
        catch (PortInUseException e) {
            throw new IllegalArgumentException(portName + " is in use");
        }
        try {
            this.serialPort.disableReceiveThreshold();
            this.serialPort.enableReceiveTimeout(100);
            this.serialPort.setSerialPortParams(115200, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException(e.getMessage());
        }
        this.in = new BufferedInputStream(this.serialPort.getInputStream());
        while (this.in.available() > 0) {
            this.in.read();
        }
        this.out = this.serialPort.getOutputStream();
    }

    public void closeComms() throws IOException {
        this.in.close();
        this.out.close();
        this.serialPort.close();
    }
}

