/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.basestation.ExitCommand;
import com.sun.spot.peripheral.basestation.GetChannelAccessFailureCommand;
import com.sun.spot.peripheral.basestation.GetNoAckCommand;
import com.sun.spot.peripheral.basestation.GetNullPacketAfterAckWaitCommand;
import com.sun.spot.peripheral.basestation.GetRadioPropertyCommand;
import com.sun.spot.peripheral.basestation.GetWrongAckCommand;
import com.sun.spot.peripheral.basestation.ICommand;
import com.sun.spot.peripheral.basestation.MCPSDataIndicationCommand;
import com.sun.spot.peripheral.basestation.MCPSDataRequestCommand;
import com.sun.spot.peripheral.basestation.MLMEGetCommand;
import com.sun.spot.peripheral.basestation.MLMEResetCommand;
import com.sun.spot.peripheral.basestation.MLMERxEnableCommand;
import com.sun.spot.peripheral.basestation.MLMESetCommand;
import com.sun.spot.peripheral.basestation.MLMEStartCommand;
import com.sun.spot.peripheral.basestation.ResetProxyCommand;
import com.sun.spot.peripheral.basestation.SetPLMETransmitPowerCommand;
import com.sun.spot.peripheral.radio.HostSerialPipe;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.IProprietaryMAC;
import com.sun.spot.peripheral.radio.MAC_InvalidParameterException;
import com.sun.spot.peripheral.radio.ProxyMACCommandExecutor;
import com.sun.spot.peripheral.radio.RadioPacket;
import java.io.IOException;

class ProxyMAC
implements I802_15_4_MAC,
IProprietaryMAC {
    final ProxyMACCommandExecutor commandExecutor;
    private HostSerialPipe serialPipe;

    public ProxyMAC() {
        try {
            String port = System.getProperty("SERIAL_PORT");
            if (port == null) {
                throw new SpotFatalException("SERIAL_PORT property must be set to access the basestation.");
            }
            if ("dummyport".equalsIgnoreCase(port)) {
                throw new SpotFatalException("No basestation available.");
            }
            this.serialPipe = new HostSerialPipe();
            this.serialPipe.initComms(System.getProperty("SERIAL_PORT"));
        }
        catch (IOException e) {
            throw new SpotFatalException(e.getMessage());
        }
        try {
            this.commandExecutor = new ProxyMACCommandExecutor(this.serialPipe);
            this.resetProxy();
        }
        catch (RuntimeException e) {
            this.closeSerialPipe();
            throw e;
        }
    }

    public void closeSerialPipe() {
        try {
            this.serialPipe.closeComms();
        }
        catch (IOException e) {
            throw new SpotFatalException(e.getMessage());
        }
        finally {
            this.serialPipe = null;
        }
    }

    public synchronized int mcpsDataRequest(RadioPacket rp) {
        int result = (Integer)this.executeRemoteCommand(new MCPSDataRequestCommand().with(rp));
        rp.timestamp = System.currentTimeMillis();
        return result;
    }

    public void mcpsDataIndication(RadioPacket rp) {
        RadioPacket howWeWantTheRadioPacketToBe = (RadioPacket)this.executeRemoteCommand((ICommand)new MCPSDataIndicationCommand());
        rp.copyFrom(howWeWantTheRadioPacketToBe);
        rp.timestamp = System.currentTimeMillis();
    }

    public void mlmeStart(short panId, int channel) throws MAC_InvalidParameterException {
        this.executeRemoteCommand(new MLMEStartCommand().with(panId, channel));
    }

    public synchronized void mlmeReset(boolean resetAttribs) {
        this.executeRemoteCommand(new MLMEResetCommand().with(resetAttribs));
    }

    public long mlmeGet(int attribute) throws MAC_InvalidParameterException {
        return (Long)this.executeRemoteCommand((ICommand)new MLMEGetCommand().with(attribute));
    }

    public void mlmeSet(int attribute, long value) throws MAC_InvalidParameterException {
        this.executeRemoteCommand(new MLMESetCommand().with(attribute, value));
    }

    public void mlmeRxEnable(int rxOnDuration) {
        this.executeRemoteCommand(new MLMERxEnableCommand().with(rxOnDuration));
    }

    public int getNullPacketAfterAckWait() {
        return (Integer)this.executeRemoteCommand((ICommand)new GetNullPacketAfterAckWaitCommand());
    }

    public int getChannelAccessFailure() {
        return (Integer)this.executeRemoteCommand((ICommand)new GetChannelAccessFailureCommand());
    }

    public int getNoAck() {
        return (Integer)this.executeRemoteCommand((ICommand)new GetNoAckCommand());
    }

    public int getWrongAck() {
        return (Integer)this.executeRemoteCommand((ICommand)new GetWrongAckCommand());
    }

    public void setPLMETransmitPower(int power) {
        this.executeRemoteCommand(new SetPLMETransmitPowerCommand().with(power));
    }

    public int getPLMETransmitPower() {
        return ((Long)this.executeRemoteCommand((ICommand)new GetRadioPropertyCommand().with(0))).intValue();
    }

    public int getChannel() {
        return ((Long)this.executeRemoteCommand((ICommand)new GetRadioPropertyCommand().with(1))).intValue();
    }

    public int getPanId() {
        return ((Long)this.executeRemoteCommand((ICommand)new GetRadioPropertyCommand().with(2))).intValue();
    }

    public void resetProxy() {
        this.executeRemoteCommand((ICommand)new ResetProxyCommand());
    }

    public void exit() {
        this.executeRemoteCommand((ICommand)new ExitCommand());
        this.closeSerialPipe();
    }

    public void setMaxReceiveQueueLength(int maxPackets) {
    }

    public void setReceiveQueueLengthToDropBroadcastPackets(int maxPackets) {
    }

    public int getMaxReceiveQueueLength() {
        return Integer.MAX_VALUE;
    }

    public int getReceiveQueueLengthToDropBroadcastPackets() {
        return Integer.MAX_VALUE;
    }

    private Object executeRemoteCommand(ICommand command) {
        return this.commandExecutor.executeRemoteCommand(command);
    }
}

