/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.basestation.ICommand;
import com.sun.spot.peripheral.radio.BlockedCommand;
import com.sun.spot.peripheral.radio.HostSerialPipe;
import com.sun.spot.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;

final class ProxyMACCommandExecutor
extends Thread {
    private final HostSerialPipe serial;
    private final HashMap uidsToCommandSyncs = new HashMap();
    private int uid;

    public ProxyMACCommandExecutor(HostSerialPipe serial) {
        this.serial = serial;
        this.uid = new Random().nextInt();
        this.start();
    }

    public void run() {
        boolean portClosed = false;
        while (!portClosed) {
            try {
                byte[] inputBuffer = new byte[255];
                this.serial.receive(inputBuffer);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputBuffer);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                int incomingUID = dataInputStream.readInt();
                BlockedCommand blockedCommand = this.findBlockedCommand(incomingUID);
                if (blockedCommand != null) {
                    blockedCommand.unblock(dataInputStream);
                    continue;
                }
                System.out.println("Discarding " + Utils.stringify((byte[])inputBuffer));
                System.out.println("The apparent incoming uid is " + incomingUID);
                System.out.println("The last uid I sent was =" + this.uid);
            }
            catch (IOException e) {
                if (e.getMessage().indexOf("Stream closed") > -1) {
                    portClosed = true;
                    continue;
                }
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public Object executeRemoteCommand(ICommand command) {
        try {
            int myId = this.getNextUid();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(myId);
            command.writeOnto(dataOutputStream);
            byte[] payload = byteArrayOutputStream.toByteArray();
            BlockedCommand commandSync = new BlockedCommand(command);
            this.putBlockedCommand(myId, commandSync);
            return commandSync.sendAndWaitForResult(this.serial, payload, command.getTimeout());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SpotFatalException("don't expect any non-RuntimeException exceptions " + e);
        }
    }

    private synchronized int getNextUid() {
        return ++this.uid;
    }

    private synchronized void putBlockedCommand(int myId, BlockedCommand commandSync) {
        this.uidsToCommandSyncs.put(new Integer(myId), commandSync);
    }

    private synchronized BlockedCommand findBlockedCommand(int incomingUID) {
        return (BlockedCommand)this.uidsToCommandSyncs.remove(new Integer(incomingUID));
    }
}

