/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.ISleepManager;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.BroadcastChannel;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.I802_15_4_PHY;
import com.sun.spot.peripheral.radio.IConnectionID;
import com.sun.spot.peripheral.radio.IProprietaryRadio;
import com.sun.spot.peripheral.radio.IRadioPolicyManager;
import com.sun.spot.peripheral.radio.ProxyMAC;
import com.sun.spot.peripheral.radio.RadioPolicy;
import com.sun.spot.peripheral.radio.RadioPolicyManager;
import com.sun.spot.peripheral.radio.SocketMAC;
import com.sun.spot.resourcesharing.IResourceRegistry;
import com.sun.spot.resourcesharing.IResourceRegistryMaster;
import com.sun.spot.resourcesharing.ResourceRegistryChild;
import com.sun.spot.resourcesharing.ResourceRegistryMaster;

public class RadioFactory {
    private static final int SOCKET_MAC_DATA_CHANNEL_PORT = 4447;
    private static final int SOCKET_MAC_COMMAND_CHANNEL_PORT = 4446;
    private static I802_15_4_MAC theRadioMAC;
    private static I802_15_4_MAC theSocketMAC;
    public static final String SPOT_BASESTATION_MANAGER = "spot.basestation.manager";
    public static final String SPOT_BASESTATION_SHARING = "spot.basestation.sharing";
    private static IRadioPolicyManager radioPolicyManager;
    private static IResourceRegistry resourceRegistry;

    private RadioFactory() {
    }

    public static synchronized I802_15_4_MAC getI802_15_4_MAC() {
        if (theRadioMAC == null) {
            theRadioMAC = new ProxyMAC();
        }
        return theRadioMAC;
    }

    public static synchronized I802_15_4_MAC getSocketMAC() {
        if (theSocketMAC == null) {
            theSocketMAC = new SocketMAC(new BroadcastChannel(4446), new BroadcastChannel(4447));
        }
        return theSocketMAC;
    }

    public static boolean isRunningOnHost() {
        return true;
    }

    public static boolean isMasterIsolate() {
        return true;
    }

    public static void setProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static void setPersistentProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static IResourceRegistry getResourceRegistry() {
        if (resourceRegistry == null) {
            resourceRegistry = new ResourceRegistryChild(0, (IResourceRegistryMaster)new ResourceRegistryMaster());
        }
        return resourceRegistry;
    }

    public static ISleepManager getSleepManager() {
        throw new SpotFatalException("Not implemented on host");
    }

    public static synchronized IRadioPolicyManager getRadioPolicyManager() {
        if (radioPolicyManager == null) {
            if (Boolean.getBoolean(SPOT_BASESTATION_SHARING) && !Boolean.getBoolean(SPOT_BASESTATION_MANAGER)) {
                radioPolicyManager = new IRadioPolicyManager(){

                    public long getIEEEAddress() {
                        return RadioFactory.getSocketMAC().mlmeGet(368);
                    }

                    public void policyHasChanged(IConnectionID conn, RadioPolicy selection) {
                    }

                    public void registerConnection(IConnectionID conn) {
                    }

                    public void deregisterConnection(IConnectionID conn) {
                    }

                    public boolean isRadioReceiverOn() {
                        return true;
                    }

                    public boolean setRxOn(boolean rxState) {
                        return true;
                    }

                    public int getChannelNumber() {
                        return 0;
                    }

                    public int getOutputPower() {
                        return 0;
                    }

                    public short getPanId() {
                        return 0;
                    }

                    public void setChannelNumber(int channel) {
                        throw new SpotFatalException("Cannot change radio channel for shared basestation.");
                    }

                    public void setPanId(short pid) {
                        throw new SpotFatalException("Cannot change radio pan id for shared basestation.");
                    }

                    public void setOutputPower(int power) {
                        throw new SpotFatalException("Cannot change radio transmit power for shared basestation.");
                    }

                    public void closeBaseStation() {
                    }
                };
            } else {
                I802_15_4_MAC mac = RadioFactory.getI802_15_4_MAC();
                int channel = 26;
                int panId = 3;
                int power = 0;
                if (theRadioMAC instanceof ProxyMAC) {
                    channel = ((ProxyMAC)theRadioMAC).getChannel();
                    panId = ((ProxyMAC)theRadioMAC).getPanId();
                    power = ((ProxyMAC)theRadioMAC).getPLMETransmitPower();
                }
                radioPolicyManager = new RadioPolicyManager(mac, channel, (short)panId, power);
            }
        }
        return radioPolicyManager;
    }

    public static void setRadioPolicyManager(IRadioPolicyManager radioPolicyManager) {
        RadioFactory.radioPolicyManager = radioPolicyManager;
    }

    public static I802_15_4_PHY getI802_15_4_PHY() {
        throw new SpotFatalException("Not implemented on host");
    }

    public static I802_15_4_MAC[] getI802_15_4_MACs() {
        I802_15_4_MAC[] macArray = Boolean.getBoolean(SPOT_BASESTATION_SHARING) ? (Boolean.getBoolean(SPOT_BASESTATION_MANAGER) ? new I802_15_4_MAC[]{RadioFactory.getSocketMAC(), RadioFactory.getI802_15_4_MAC()} : new I802_15_4_MAC[]{RadioFactory.getSocketMAC()}) : new I802_15_4_MAC[]{RadioFactory.getI802_15_4_MAC()};
        return macArray;
    }

    public static IProprietaryRadio getIProprietaryRadio() {
        throw new SpotFatalException("Not implemented on host");
    }

    public static void setAsDaemonThread(Thread thread) {
        thread.setDaemon(true);
    }

    public static void closeBaseStation() {
        if (theRadioMAC != null) {
            ((ProxyMAC)theRadioMAC).closeSerialPipe();
            theRadioMAC = null;
        }
    }

    static void setRadioMAC(I802_15_4_MAC radioMAC) {
        theRadioMAC = radioMAC;
    }

    static void setSocketMAC(I802_15_4_MAC socketMAC) {
        theSocketMAC = socketMAC;
    }
}

