/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral.radio;

import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.BroadcastRxThread;
import com.sun.spot.peripheral.radio.I802_15_4_MAC;
import com.sun.spot.peripheral.radio.IProprietaryMAC;
import com.sun.spot.peripheral.radio.ISocketMacBroadcastChannel;
import com.sun.spot.peripheral.radio.MAC_InvalidParameterException;
import com.sun.spot.peripheral.radio.RadioPacket;
import com.sun.spot.util.Queue;
import com.sun.spot.util.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Hashtable;

class SocketMAC
implements I802_15_4_MAC,
IProprietaryMAC {
    private static final int DISCOVER_TIMEOUT = 1000;
    public static final byte CMD_DISCOVER = 1;
    private ISocketMacBroadcastChannel commandBroadcastChannel;
    private ISocketMacBroadcastChannel packetBroadcastChannel;
    private BroadcastRxThread broadcastCommandRxThread;
    private BroadcastRxThread broadcastPacketRxThread;
    private ServerSocket serverSocket;
    long extendedAddress;
    private Queue rxQueue;
    private Hashtable clientSockets;
    private byte macDSN;

    public SocketMAC(ISocketMacBroadcastChannel commandBroadcastChannel, ISocketMacBroadcastChannel packetBroadcastChannel) {
        this.packetBroadcastChannel = packetBroadcastChannel;
        this.commandBroadcastChannel = commandBroadcastChannel;
        this.rxQueue = new Queue();
        this.clientSockets = new Hashtable();
        this.mlmeStart((short)0, 0);
    }

    public synchronized int mcpsDataRequest(RadioPacket rp) {
        rp.setDSN(this.getDSN());
        int result = 233;
        try {
            if (rp.getDestinationAddress() == 65535L) {
                this.packetBroadcastChannel.broadcast(rp.buffer);
                result = 0;
            } else {
                ClientSocketListener clientSocket = this.getClientSocketFor(rp.getDestinationAddress());
                if (clientSocket != null) {
                    OutputStream outputStream = clientSocket.getOutputStream();
                    outputStream.write(rp.buffer, 0, rp.buffer[0] + 1);
                    outputStream.flush();
                    if (clientSocket.waitForAck(rp.getDataSequenceNumber())) {
                        result = 0;
                    }
                }
            }
            rp.timestamp = System.currentTimeMillis();
        }
        catch (IOException e) {
            throw new SpotFatalException("Got IOException while sending over SocketMac " + e.getMessage());
        }
        return result;
    }

    public void mcpsDataIndication(RadioPacket rp) {
        rp.copyFrom((RadioPacket)this.rxQueue.get());
    }

    public void mlmeStart(short panId, int channel) throws MAC_InvalidParameterException {
        try {
            if (this.serverSocket == null) {
                this.serverSocket = new ServerSocket();
                this.serverSocket.bind(null);
                long ipAddress = Utils.readBigEndInt((byte[])InetAddress.getLocalHost().getAddress(), (int)0);
                this.extendedAddress = ipAddress << 32 | (long)this.serverSocket.getLocalPort() & 0xFFFFFFFFL;
                this.broadcastCommandRxThread = new CommandRxThread(this, this.commandBroadcastChannel);
                this.broadcastCommandRxThread.setDaemon(true);
                this.broadcastCommandRxThread.start();
                this.broadcastPacketRxThread = new BroadcastPacketRxThread(this, this.packetBroadcastChannel);
                this.broadcastPacketRxThread.setDaemon(true);
                this.broadcastPacketRxThread.start();
            }
        }
        catch (IOException e) {
            throw new SpotFatalException("Encountered IO Exception attempting to open server socket: " + e.getMessage());
        }
    }

    public void mlmeReset(boolean resetAttribs) {
        this.rxQueue = new Queue();
    }

    public long mlmeGet(int attribute) throws MAC_InvalidParameterException {
        long result;
        switch (attribute) {
            case 368: {
                result = this.extendedAddress;
                break;
            }
            case 82: {
                result = 1L;
                break;
            }
            default: {
                throw new MAC_InvalidParameterException();
            }
        }
        return result;
    }

    public void mlmeSet(int attribute, long value) throws MAC_InvalidParameterException {
        switch (attribute) {
            case 82: {
                if (value != 0L) break;
                throw new MAC_InvalidParameterException("Not supported on host");
            }
            default: {
                throw new MAC_InvalidParameterException();
            }
        }
    }

    public void mlmeRxEnable(int rxOnDuration) {
    }

    void closedown() throws IOException {
        this.broadcastCommandRxThread.interrupt();
        this.broadcastPacketRxThread.interrupt();
        this.serverSocket.close();
    }

    private void discoverStream(long address) throws SocketException, IOException {
        byte[] command = new byte[22];
        command[0] = 13;
        command[1] = 1;
        Utils.writeBigEndLong((byte[])command, (int)2, (long)address);
        Utils.writeBigEndInt((byte[])command, (int)10, (int)this.serverSocket.getLocalPort());
        Utils.writeBigEndLong((byte[])command, (int)14, (long)this.extendedAddress);
        this.commandBroadcastChannel.broadcast(command);
        this.serverSocket.setSoTimeout(1000);
        try {
            Socket clientSocket = this.serverSocket.accept();
            clientSocket.setTcpNoDelay(true);
            this.addClientSocket(address, clientSocket);
        }
        catch (SocketTimeoutException e) {
            // empty catch block
        }
    }

    private synchronized void addClientSocket(long address, Socket clientSocket) throws IOException {
        ClientSocketListener clientSocketListener = new ClientSocketListener(clientSocket, address);
        this.clientSockets.put(new Long(address), clientSocketListener);
        clientSocketListener.setDaemon(true);
        clientSocketListener.start();
    }

    private synchronized ClientSocketListener getClientSocketFor(long address) throws IOException {
        if (!this.clientSockets.containsKey(new Long(address))) {
            this.discoverStream(address);
        }
        return (ClientSocketListener)this.clientSockets.get(new Long(address));
    }

    private synchronized void closeClientSocketFor(long remoteAddress) throws IOException {
        ClientSocketListener existingClientSocketListener = (ClientSocketListener)this.clientSockets.remove(new Long(remoteAddress));
        if (existingClientSocketListener != null) {
            existingClientSocketListener.close();
        }
    }

    private synchronized byte getDSN() {
        byte by = this.macDSN;
        this.macDSN = (byte)(by + 1);
        return by;
    }

    public static boolean isHostAppAddress(long ieeeAddress) {
        byte[] ip = new byte[4];
        Utils.writeBigEndInt((byte[])ip, (int)0, (int)((int)(ieeeAddress >> 32)));
        try {
            InetAddress theAddress = InetAddress.getByAddress(ip);
            return theAddress.isSiteLocalAddress() || theAddress.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public int getChannelAccessFailure() {
        return 0;
    }

    public int getMaxReceiveQueueLength() {
        return 0;
    }

    public int getNoAck() {
        return 0;
    }

    public int getNullPacketAfterAckWait() {
        return 0;
    }

    public int getPLMETransmitPower() {
        return 0;
    }

    public int getReceiveQueueLengthToDropBroadcastPackets() {
        return 0;
    }

    public int getWrongAck() {
        return 0;
    }

    public void setMaxReceiveQueueLength(int maxPackets) {
    }

    public void setPLMETransmitPower(int power) {
    }

    public void setReceiveQueueLengthToDropBroadcastPackets(int maxPackets) {
    }

    private class CommandRxThread
    extends BroadcastRxThread {
        public CommandRxThread(SocketMAC mac, ISocketMacBroadcastChannel broadcastChannel) {
            super("Socket MAC broadcast command rx thread", mac, broadcastChannel);
        }

        protected void processIncoming(byte[] data) throws IOException, UnknownHostException {
            switch (data[1]) {
                case 1: {
                    long requiredAddress = Utils.readBigEndLong((byte[])data, (int)2);
                    if (requiredAddress != this.mac.extendedAddress) break;
                    int remotePort = Utils.readBigEndInt((byte[])data, (int)10);
                    long remoteAddress = Utils.readBigEndLong((byte[])data, (int)14);
                    SocketMAC.this.closeClientSocketFor(remoteAddress);
                    Socket newClientSocket = new Socket(InetAddress.getByAddress(this.getIPAddress(remoteAddress)), remotePort);
                    newClientSocket.setTcpNoDelay(true);
                    SocketMAC.this.addClientSocket(remoteAddress, newClientSocket);
                    break;
                }
                default: {
                    System.out.println("" + Utils.stringify((byte[])data));
                    throw new SpotFatalException("Read bad broadcast command code " + data[1]);
                }
            }
        }

        private byte[] getIPAddress(long remoteAddress) {
            byte[] result = new byte[4];
            Utils.writeBigEndInt((byte[])result, (int)0, (int)((int)(remoteAddress >> 32)));
            return result;
        }
    }

    private class BroadcastPacketRxThread
    extends BroadcastRxThread {
        public BroadcastPacketRxThread(SocketMAC mac, ISocketMacBroadcastChannel broadcastChannel) {
            super("Socket MAC broadcast packet rx thread", mac, broadcastChannel);
        }

        protected void processIncoming(byte[] data) throws IOException, UnknownHostException {
            RadioPacket rp = RadioPacket.getBroadcastPacket();
            for (int i = 0; i < data.length; ++i) {
                rp.buffer[i] = data[i];
            }
            rp.decodeFrameControl();
            if (rp.getSourceAddress() != SocketMAC.this.extendedAddress) {
                SocketMAC.this.rxQueue.put((Object)rp);
            }
        }
    }

    private class ClientSocketListener
    extends Thread {
        private static final long ACK_TIMEOUT = 1000L;
        private BufferedInputStream bis;
        private boolean closed;
        private Socket clientSocket;
        private Queue ackQueue;
        private long remoteAddress;

        public ClientSocketListener(Socket clientSocket, long address) throws IOException {
            super("Client socket listener");
            this.clientSocket = clientSocket;
            this.bis = new BufferedInputStream(clientSocket.getInputStream());
            this.ackQueue = new Queue();
            this.remoteAddress = address;
        }

        public boolean waitForAck(byte dataSequenceNumber) throws IOException {
            RadioPacket nextAck = (RadioPacket)this.ackQueue.get(1000L);
            while (nextAck != null) {
                if (nextAck.getDataSequenceNumber() == dataSequenceNumber) {
                    return true;
                }
                nextAck = (RadioPacket)this.ackQueue.get(1000L);
            }
            SocketMAC.this.closeClientSocketFor(this.remoteAddress);
            return false;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.clientSocket.getOutputStream();
        }

        public void run() {
            while (true) {
                RadioPacket incoming = RadioPacket.getAckPacket();
                try {
                    try {
                        int firstByte = this.bis.read();
                        if (firstByte == -1) break;
                        incoming.buffer[0] = (byte)firstByte;
                        int lengthRead = this.bis.read(incoming.buffer, 1, incoming.buffer[0]);
                        if (lengthRead < incoming.buffer[0]) {
                            throw new SpotFatalException("Read short incoming packet");
                        }
                        incoming.decodeFrameControl();
                        if (incoming.isAck()) {
                            this.ackQueue.put((Object)incoming);
                            continue;
                        }
                        RadioPacket ackPacket = RadioPacket.getAckPacket();
                        ackPacket.setDSN(incoming.getDataSequenceNumber());
                        OutputStream outputStream = this.getOutputStream();
                        outputStream.write(ackPacket.buffer, 0, ackPacket.buffer[0] + 1);
                        outputStream.flush();
                        incoming.timestamp = System.currentTimeMillis();
                        SocketMAC.this.rxQueue.put((Object)incoming);
                        continue;
                    }
                    catch (SocketException e) {
                        SocketMAC.this.closeClientSocketFor(this.remoteAddress);
                    }
                }
                catch (IOException e) {
                    if (this.closed) break;
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public void close() throws IOException {
            this.closed = true;
            this.clientSocket.close();
            this.interrupt();
        }
    }
}

