/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.common;

import com.sun.kvem.midp.io.j2se.wma.common.TextEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class DatagramRecord {
    public static final String SEND_TIME_HEADER = "Date";
    public static final String ADDRESS_HEADER = "Address";
    public static final String SENDER_ADDRESS_HEADER = "SenderAddress";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    public static final String SEGMENTS_HEADER = "Segments";
    public static final String FRAGMENT_HEADER = "Fragment";
    public static final String FRAGMENT_SIZE_HEADER = "Fragment-Size";
    public static final String FRAGMENT_OFFSET_HEADER = "Fragment-Offset";
    public static final String TEXT_ENCODING_HEADER = "Text-Encoding";
    public static final String CBS_ADDRESS_HEADER = "CBSAddress";
    private static final String TOTAL_SIZE_HEADER = "Total-Size";
    public static final String CONTENT_TYPE_BINARY = "binary";
    public static final String CONTENT_TYPE_TEXT = "text";
    public static final String CONTENT_TYPE_MULTIPART = "multipart";
    public static final String UCS2_ENCODING = "ucs2";
    public static final String GSM7BIT_ENCODING = "gsm7bit";
    private static int INITIAL_SIZE = 10;
    private List keys = new Vector(INITIAL_SIZE);
    private List vals = new Vector(INITIAL_SIZE);
    private byte[] data = null;

    public String getHeader(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException();
        }
        for (n = 0; n < this.keys.size() && !string.equals(this.keys.get(n)); ++n) {
        }
        String string2 = null;
        if (n != this.keys.size()) {
            string2 = (String)this.vals.get(n);
        }
        return string2;
    }

    public synchronized String setHeader(String string, String string2) {
        int n;
        for (n = 0; n < this.keys.size() && !string.equals(this.keys.get(n)); ++n) {
        }
        String string3 = null;
        if (n == this.keys.size()) {
            this.keys.add(string);
            this.vals.add(string2);
        } else {
            string3 = (String)this.vals.get(n);
            this.vals.set(n, string2);
        }
        return string3;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public boolean addData(DatagramRecord datagramRecord) throws IOException {
        if (datagramRecord != null && !datagramRecord.getHeader(SEND_TIME_HEADER).equals(this.getHeader(SEND_TIME_HEADER))) {
            throw new IOException("Bad fragmentation");
        }
        String string = datagramRecord != null ? datagramRecord.getHeader(TOTAL_SIZE_HEADER) : null;
        String string2 = this.getHeader(CONTENT_LENGTH_HEADER);
        String string3 = this.getHeader(FRAGMENT_SIZE_HEADER);
        int n = 0;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        if (string == null) {
            byte[] byArray = new byte[n2];
            if (this.data != null) {
                n = this.data.length;
                System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            }
            string = String.valueOf(this.data.length);
            this.setHeader(TOTAL_SIZE_HEADER, string);
            this.data = byArray;
        } else {
            int n3 = 0;
            int n4 = 0;
            try {
                n3 = Integer.parseInt(this.getHeader(FRAGMENT_OFFSET_HEADER));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            try {
                n = Integer.parseInt(this.getHeader(FRAGMENT_SIZE_HEADER));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            byte[] byArray = datagramRecord.getData();
            System.arraycopy(this.data, 0, byArray, n3, n);
            this.data = byArray;
            try {
                n4 = Integer.parseInt(string);
                n4 += n;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            string = String.valueOf(n4);
            this.setHeader(TOTAL_SIZE_HEADER, string);
            n = n4;
        }
        return n == n2;
    }

    public boolean parseData(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        String string2 = null;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bl && byArray[i] == 58) {
                n2 = i;
                bl = true;
                string = new String(byArray, n4, n2 - n4);
                if (n6 == 0 && string.equals("Buffer")) {
                    n6 = i;
                    while (byArray[n6] != 10) {
                        ++n6;
                    }
                    ++n6;
                }
            }
            if (n6 > 0) {
                this.data = new byte[n - n6];
                int n7 = n6;
                int n8 = 0;
                while (n7 < n) {
                    this.data[n8] = byArray[n7];
                    ++n7;
                    ++n8;
                    ++i;
                }
                continue;
            }
            if (byArray[i] != 10) continue;
            n3 = i;
            string2 = new String(byArray, n2 + 1, n3 - n2 - 1).trim();
            this.setHeader(string, string2);
            n4 = n3 + 1;
            bl = false;
        }
        try {
            n5 = Integer.parseInt(this.getHeader(SEGMENTS_HEADER));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n5 > 1;
    }

    public byte[] getFormattedData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < this.keys.size(); ++i) {
                byteArrayOutputStream.write(((String)this.keys.get(i) + ": " + (String)this.vals.get(i) + "\n").getBytes());
            }
            if (this.getHeader(CBS_ADDRESS_HEADER) != null && !"".equals(this.getHeader(CBS_ADDRESS_HEADER))) {
                byteArrayOutputStream.write("Buffer:\n".getBytes());
            } else {
                byteArrayOutputStream.write("Buffer: \n".getBytes());
            }
            byteArrayOutputStream.write(this.data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.keys.size(); ++i) {
            stringBuffer.append(this.keys.get(i)).append(": ").append((String)this.vals.get(i)).append("\n");
        }
        if (this.getHeader(CONTENT_TYPE_HEADER).equals(CONTENT_TYPE_TEXT)) {
            String string;
            String string2 = this.getHeader(TEXT_ENCODING_HEADER);
            if (string2 == null || string2.equals(UCS2_ENCODING)) {
                string = TextEncoder.toString(this.data);
            } else {
                byte[] byArray = TextEncoder.decode(this.data);
                string = TextEncoder.toString(byArray);
            }
            stringBuffer.append("Buffer: ").append(string).append("\n");
        } else {
            stringBuffer.append("Buffer: (binary)\n").append(new String(this.data)).append("\n");
        }
        return stringBuffer.toString();
    }
}

