/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.tools.http;

import com.sun.kvem.tools.http.Handler;
import com.sun.kvem.tools.http.RequestListener;
import com.sun.kvem.tools.http.ServerConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class HttpServer
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(HttpServer.class);
    public static final int SOCKET_WAIT_TIMEOUT = 5000;
    protected ServerConfiguration configuration;
    private volatile boolean keepWorking = true;
    private List<RequestListener> listeners = new ArrayList<RequestListener>();
    private Vector idleHandlers = new Vector();
    private Vector handlers = new Vector();

    public HttpServer(ServerConfiguration serverConfiguration) {
        super("HTTP Server");
        this.configuration = serverConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleHandler(Handler handler) {
        Vector vector = this.idleHandlers;
        synchronized (vector) {
            this.idleHandlers.addElement(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.keepWorking) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = this.createServerSocket();
                if (serverSocket == null) {
                    this.handleServerNotStarted();
                    return;
                }
                this.setupHostName();
                this.handleServerStarted();
                Object object = this;
                synchronized (object) {
                    this.notify();
                }
                serverSocket.setSoTimeout(5000);
                while (this.keepWorking) {
                    try {
                        object = serverSocket.accept();
                        this.handleClient((Socket)object);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
            }
            catch (BindException bindException) {
                LOGGER.error((Object)bindException, (Throwable)bindException);
                this.configuration.setPort(this.configuration.getPort() + 1);
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception, (Throwable)exception);
            }
            finally {
                if (serverSocket == null || serverSocket.isClosed()) continue;
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.stopAllHandlers();
    }

    public void addRequestListener(RequestListener requestListener) {
        this.listeners.add(requestListener);
    }

    public void removeRequestListener(RequestListener requestListener) {
        this.listeners.remove(requestListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllHandlers() {
        Vector vector = this.handlers;
        synchronized (vector) {
            while (this.handlers.size() > 0) {
                Handler handler = (Handler)this.handlers.remove(0);
                handler.stopHandling();
            }
        }
    }

    public void stopServing() {
        this.keepWorking = false;
    }

    protected void handleServerStarted() {
        LOGGER.info((Object)"HTTP server started!");
    }

    protected void handleServerNotStarted() {
        LOGGER.warn((Object)"OTA server not started!");
    }

    protected void handleClient(Socket socket) {
        Handler handler = this.getIddleHandler();
        handler.setSocket(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getIddleHandler() {
        Vector vector = this.idleHandlers;
        synchronized (vector) {
            if (this.idleHandlers.isEmpty()) {
                return this.createNewHandler();
            }
            Handler handler = (Handler)this.idleHandlers.remove(0);
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Handler createNewHandler() {
        Handler handler = new Handler(this, "HTTP server handler " + (this.handlers.size() + 1));
        handler.setRequestListeners(this.listeners);
        Vector vector = this.handlers;
        synchronized (vector) {
            this.handlers.add(handler);
            handler.start();
        }
        return handler;
    }

    protected void setupHostName() throws UnknownHostException {
        if (!this.configuration.getHostName().equals("localhost")) {
            this.configuration.setHostName(InetAddress.getLocalHost().getCanonicalHostName());
        }
    }

    protected synchronized ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket;
        if (this.configuration.willUseDynamicPort()) {
            serverSocket = new ServerSocket(0);
            this.configuration.setPort(serverSocket.getLocalPort());
        } else {
            serverSocket = new ServerSocket(this.configuration.getPort());
        }
        return serverSocket;
    }

    public synchronized int getPort() {
        return this.configuration.getPort();
    }

    public synchronized String getHostName() {
        return this.configuration.getHostName();
    }

    public synchronized File getRootDirectory() {
        return this.configuration.getRootDir();
    }
}

