/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.beansbinding;

import com.sun.kvem.beansbinding.Property;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyWrapper<T>
implements Property<T> {
    final Object bean;
    private final PropertyDescriptor propertyDescriptor;
    private final EventSetDescriptor eventSetDescriptor;

    public PropertyWrapper(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("Bean is null");
        }
        if (string == null) {
            throw new NullPointerException("PropertyName is null");
        }
        try {
            this.propertyDescriptor = this.getPropertyDescriptor(object.getClass(), string);
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalArgumentException("Property " + string + " not found in class " + object.getClass());
        }
        try {
            this.eventSetDescriptor = this.getEventSetDescriptor(object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalArgumentException("Bean has not valid add/remove methods for PropertyChangeListener");
        }
        this.bean = object;
    }

    @Override
    public T getValue() {
        Method method = this.propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new UnsupportedOperationException("Unreadable");
        }
        try {
            return (T)method.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unreadable", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Unreadable", invocationTargetException);
        }
    }

    @Override
    public void setValue(T t) {
        Method method = this.propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new UnsupportedOperationException("Unwriteble");
        }
        try {
            method.invoke(this.bean, t);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Unwriteble", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unwriteble", illegalAccessException);
        }
    }

    @Override
    public Class<?> getWriteType() {
        if (this.propertyDescriptor.getWriteMethod() == null) {
            throw new UnsupportedOperationException("Unwriteble");
        }
        return this.propertyDescriptor.getPropertyType();
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        Method method = this.eventSetDescriptor.getAddListenerMethod();
        try {
            method.invoke(this.bean, propertyChangeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("Unsupported add listener method", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unsupported add listener method", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Unsupported add listener method", invocationTargetException);
        }
    }

    @Override
    public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
        Method method = this.eventSetDescriptor.getRemoveListenerMethod();
        try {
            method.invoke(this.bean, propertyChangeListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("Unsupported remove listener method", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unsupported remove listener method", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Unsupported remove listener method", invocationTargetException);
        }
    }

    private final PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String string) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        throw new IntrospectionException("Property \"" + string + "\" not found in bean " + clazz);
    }

    private final EventSetDescriptor getEventSetDescriptor(Class<?> clazz) throws IntrospectionException {
        for (EventSetDescriptor eventSetDescriptor : Introspector.getBeanInfo(clazz).getEventSetDescriptors()) {
            if (eventSetDescriptor.getListenerType() != PropertyChangeListener.class) continue;
            return eventSetDescriptor;
        }
        throw new IntrospectionException("PropertyChangeListener EventSetDescriptor not found");
    }
}

