/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.beansbinding.adapters;

import com.sun.kvem.beansbinding.adapters.BeanAdapterBase;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class JTextComponentAdapter
extends BeanAdapterBase {
    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_TEXT_ON_ACTION_OR_FOCUS_LOST = "text_ON_ACTION_OR_FOCUS_LOST";
    public static final String PROPERTY_TEXT_ON_FOCUS_LOST = "text_ON_FOCUS_LOST";
    private JTextComponent component;
    private Document document;
    private boolean inDocumentListener;
    private boolean installedFilter;
    private String cachedText;
    private Handler handler;

    public JTextComponentAdapter(JTextComponent jTextComponent, String string) {
        super(string);
        this.component = jTextComponent;
    }

    public String getText() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.component.getText();
    }

    public String getText_ON_ACTION_OR_FOCUS_LOST() {
        return this.getText();
    }

    public String getText_ON_FOCUS_LOST() {
        return this.getText();
    }

    public void setText(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        this.component.setText(string);
        this.component.setCaretPosition(0);
        this.cachedText = string;
    }

    public void setText_ON_ACTION_OR_FOCUS_LOST(String string) {
        this.setText(string);
    }

    public void setText_ON_FOCUS_LOST(String string) {
        this.setText(string);
    }

    @Override
    protected void listeningStarted() {
        assert (SwingUtilities.isEventDispatchThread());
        this.cachedText = this.getText();
        this.handler = new Handler();
        this.component.addPropertyChangeListener("document", this.handler);
        if (this.property != PROPERTY_TEXT) {
            this.component.addFocusListener(this.handler);
        }
        if (this.property == PROPERTY_TEXT_ON_ACTION_OR_FOCUS_LOST && this.component instanceof JTextField) {
            ((JTextField)this.component).addActionListener(this.handler);
        }
        this.document = this.component.getDocument();
        this.installDocumentListener();
    }

    @Override
    protected void listeningStopped() {
        this.cachedText = null;
        this.component.removePropertyChangeListener("document", this.handler);
        if (this.property != PROPERTY_TEXT) {
            this.component.removeFocusListener(this.handler);
        }
        if (this.property == PROPERTY_TEXT_ON_ACTION_OR_FOCUS_LOST && this.component instanceof JTextField) {
            ((JTextField)this.component).removeActionListener(this.handler);
        }
        this.uninstallDocumentListener();
        this.document = null;
        this.handler = null;
    }

    private void installDocumentListener() {
        boolean bl;
        if (this.property != PROPERTY_TEXT) {
            return;
        }
        boolean bl2 = bl = !(this.component instanceof JFormattedTextField);
        if (bl && this.document instanceof AbstractDocument && ((AbstractDocument)this.document).getDocumentFilter() == null) {
            ((AbstractDocument)this.document).setDocumentFilter(this.handler);
            this.installedFilter = true;
        } else {
            this.document.addDocumentListener(this.handler);
            this.installedFilter = false;
        }
    }

    private void uninstallDocumentListener() {
        if (this.property != PROPERTY_TEXT) {
            return;
        }
        if (this.installedFilter) {
            AbstractDocument abstractDocument = (AbstractDocument)this.document;
            if (abstractDocument.getDocumentFilter() == this.handler) {
                abstractDocument.setDocumentFilter(null);
            }
        } else {
            this.document.removeDocumentListener(this.handler);
        }
    }

    private class Handler
    extends DocumentFilter
    implements ActionListener,
    DocumentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        private void updateText() {
            String string = JTextComponentAdapter.this.cachedText;
            JTextComponentAdapter.this.cachedText = JTextComponentAdapter.this.getText();
            JTextComponentAdapter.this.firePropertyChange(string, JTextComponentAdapter.this.cachedText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void documentTextChanged() {
            try {
                JTextComponentAdapter.this.inDocumentListener = true;
                this.textChanged();
            }
            finally {
                JTextComponentAdapter.this.inDocumentListener = false;
            }
        }

        private void textChanged() {
            this.updateText();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTextComponentAdapter.this.uninstallDocumentListener();
            JTextComponentAdapter.this.document = JTextComponentAdapter.this.component.getDocument();
            JTextComponentAdapter.this.installDocumentListener();
            this.updateText();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.updateText();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.updateText();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentTextChanged();
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            super.replace(filterBypass, n, n2, string, attributeSet);
            this.textChanged();
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(filterBypass, n, string, attributeSet);
            this.textChanged();
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            super.remove(filterBypass, n, n2);
            this.textChanged();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

