/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.impl;

import com.sun.kvem.sensor.api.ConnectionType;
import com.sun.kvem.sensor.api.ContextType;
import com.sun.kvem.sensor.api.GuiSensorProxy;
import com.sun.kvem.sensor.api.Sensor;
import com.sun.kvem.sensor.api.SensorDataWriter;
import com.sun.kvem.sensor.impl.DefaultGuiChannelProxy;
import com.sun.kvem.sensor.impl.DefaultSensorDataWriter;
import com.sun.kvem.sensor.impl.SensorControllersPanel;
import com.sun.kvem.sensor.model.Data;
import com.sun.kvem.sensor.model.SensorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class DefaultGuiSensorProxy
implements GuiSensorProxy {
    private final SensorModel sensor = new SensorModel();
    private SensorControllersPanel guiControls;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final PropertyChangeListener propertyChangeForwarder = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(DefaultGuiSensorProxy.this, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            propertyChangeEvent2.setPropagationId(propertyChangeEvent.getPropagationId());
            DefaultGuiSensorProxy.this.pcs.firePropertyChange(propertyChangeEvent2);
        }
    };
    private List<DefaultGuiChannelProxy> channelProxies = new ArrayList<DefaultGuiChannelProxy>();
    private Map<String, String> sps;

    public DefaultGuiSensorProxy() {
        this.sensor.addPropertyChangeListener(this.propertyChangeForwarder);
        this.sensor.setAvailable(true);
    }

    public void create() {
        for (DefaultGuiChannelProxy defaultGuiChannelProxy : this.channelProxies) {
            this.sensor.addChannel(defaultGuiChannelProxy.getChannelInfo());
        }
        this.guiControls = new SensorControllersPanel(this.sps);
    }

    public void start() {
        this.guiControls.bind(this.sensor);
    }

    @Override
    public SensorDataWriter getSensorDataWriter() {
        return DefaultSensorDataWriter.getInstance();
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean finish() {
        return true;
    }

    @Override
    public Data measureData(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n >= this.sensor.getChannels().length) {
            return null;
        }
        return new Data(this.sensor.getChannels(n).getValue(), 0.05f, true);
    }

    @Override
    public boolean isAvailableWritable() {
        return this.sensor.isAvailableWritable();
    }

    @Override
    public JComponent getGuiControls() {
        return this.guiControls;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void setDescription(String string) {
        this.sensor.setDescription(string);
    }

    public void setQuantity(String string) {
        this.sensor.setQuantity(string);
    }

    public void setContext(String string) {
        this.sensor.setContextType(ContextType.getByString(string));
    }

    public void setConnection(String string) {
        this.sensor.setConnType(ConnectionType.getByString(string));
    }

    public void setModel(String string) {
        this.sensor.setModel(string);
    }

    public void setMaxBuffer(int n) {
        this.sensor.setMaxBufSize(n);
    }

    public void addChannel(DefaultGuiChannelProxy defaultGuiChannelProxy) {
        this.channelProxies.add(defaultGuiChannelProxy);
    }

    public void setScriptPlayerStrings(Map<String, String> map) {
        this.sps = map;
    }

    @Override
    public Sensor getSensorInfo() {
        return this.sensor;
    }
}

