/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.sensor.impl;

import com.sun.kvem.sensor.api.Channel;
import com.sun.kvem.sensor.impl.ChannelControllerPanel;
import com.sun.kvem.sensor.impl.ScriptPlayerPanel;
import com.sun.kvem.sensor.model.ChannelModel;
import com.sun.kvem.sensor.model.SensorModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class SensorControllersPanel
extends JPanel {
    private final JPanel channelsPanel = new JPanel();
    private Map<String, String> strings;

    public SensorControllersPanel(Map<String, String> map) {
        this.strings = map;
        this.setLayout(new BorderLayout());
        this.channelsPanel.setLayout(new BoxLayout(this.channelsPanel, 3));
        this.add((Component)this.channelsPanel, "North");
    }

    public void bind(final SensorModel sensorModel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                assert (SwingUtilities.isEventDispatchThread());
                for (Channel channel : sensorModel.getChannels()) {
                    ChannelControllerPanel channelControllerPanel = new ChannelControllerPanel();
                    SensorControllersPanel.this.channelsPanel.add(channelControllerPanel);
                    channelControllerPanel.bind((ChannelModel)channel);
                }
                ScriptPlayerPanel scriptPlayerPanel = new ScriptPlayerPanel(SensorControllersPanel.this.strings);
                SensorControllersPanel.this.add(scriptPlayerPanel);
                scriptPlayerPanel.bind(sensorModel);
                SensorControllersPanel.this.invalidate();
                SensorControllersPanel.this.validate();
                SensorControllersPanel.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

