/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.kvem.ButtonsListener;
import com.sun.kvem.DeviceInput;
import com.sun.kvem.DeviceStateSpi;
import com.sun.kvem.ImageComponent;
import com.sun.kvem.InputAwareControl;
import com.sun.kvem.Orientation;
import com.sun.kvem.PositionTranslator;
import com.sun.kvem.RotateTranslator;
import com.sun.kvem.Screen;
import com.sun.kvem.ScreenDevice;
import com.sun.kvem.SupportedOrientations;
import com.sun.kvem.VMRotationListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class AbstractEMDeviceState
extends JComponent
implements DeviceStateSpi {
    private static final Logger LOGGER = Logger.getLogger(AbstractEMDeviceState.class);
    protected int scale = 1;
    private Rectangle originalNetworkIndicatorBounds;
    protected boolean[] inputStates;
    protected int inputStateCount;
    protected List<InputAwareControl> buttonListeners = new ArrayList<InputAwareControl>();
    Orientation rotation;
    BufferedImage defaultSkin;
    BufferedImage pressedSkin;
    BufferedImage highlightedSkin;
    BufferedImage defaultSkinRotated;
    BufferedImage pressedSkinRotated;
    BufferedImage highlightedSkinRotated;
    protected Image currentSkin;
    protected ArrayList<Screen> screens = new ArrayList();
    protected JComponent device;
    protected ImageComponent networkIndicator;
    private String name;
    protected EventManagerSpi eventManager;
    private SupportedOrientations supportedOrientations = new SupportedOrientations();

    public void setNetworkIndicator(ImageComponent imageComponent) {
        this.networkIndicator = imageComponent;
    }

    public void setEventManager(EventManagerSpi eventManagerSpi) {
        this.eventManager = eventManagerSpi;
    }

    public void setDevice(JComponent jComponent) {
        this.device = jComponent;
    }

    public BufferedImage getDefaultSkin() {
        return this.defaultSkinRotated;
    }

    public BufferedImage getPressedImage() {
        return this.pressedSkinRotated;
    }

    public BufferedImage getHighlightedImage() {
        return this.highlightedSkinRotated;
    }

    public void setDefaultSkin(BufferedImage bufferedImage) {
        this.defaultSkin = bufferedImage;
    }

    public void setPressedSkin(BufferedImage bufferedImage) {
        this.pressedSkin = bufferedImage;
    }

    public void setHighlightedSkin(BufferedImage bufferedImage) {
        this.highlightedSkin = bufferedImage;
    }

    public void addScreen(Screen screen) {
        this.screens.add(screen);
    }

    public void setSupportsOrientation0(boolean bl) {
        this.supportedOrientations.set(Orientation.NORMAL, bl);
    }

    public void setSupportsOrientation90(boolean bl) {
        this.supportedOrientations.set(Orientation.RIGHT, bl);
    }

    public void setSupportsOrientation180(boolean bl) {
        this.supportedOrientations.set(Orientation.UPSIDE_DOWN, bl);
    }

    public void setSupportsOrientation270(boolean bl) {
        this.supportedOrientations.set(Orientation.LEFT, bl);
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void create() throws IllegalStateException {
        this.inputStates = new boolean[this.inputStateCount];
        if (!this.supportedOrientations.hasSupportedOrientation()) {
            throw new IllegalStateException("Device state " + this.getName() + " does not support any orientation.");
        }
    }

    public void start() {
        if (this.networkIndicator != null) {
            this.originalNetworkIndicatorBounds = this.networkIndicator.getBounds();
        }
        this.setRotation(Orientation.NORMAL);
        this.currentSkin = this.defaultSkinRotated;
        if (this.highlightedSkin == null) {
            this.highlightedSkin = this.defaultSkin;
        }
        if (this.pressedSkin == null) {
            this.pressedSkin = this.defaultSkin;
        }
        if (this.screens.size() > 0) {
            this.scale = this.screens.get(0).getScale();
        }
        for (Screen screen : this.screens) {
            if (!screen.isTouch()) continue;
            ScreenDevice screenDevice = new ScreenDevice();
            screenDevice.setScreen(screen);
            screenDevice.setEventManager(this.eventManager);
            screenDevice.setEventOnMouseMove(screen.isEventOnMouseMove());
            this.addControl(screenDevice);
        }
        this.initBounds();
    }

    private void initBounds() {
        Dimension dimension = this.getPreferredSize();
        this.setBounds(0, 0, dimension.width, dimension.height);
    }

    public SupportedOrientations getSupportedOrientations() {
        return this.supportedOrientations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void drawSkin(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        graphics.drawImage(image, n, n2, n + n3, n2 + n4, n / this.scale, n2 / this.scale, (n + n3) / this.scale, (n2 + n4) / this.scale, null);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        LOGGER.debug((Object)("Clipping area : " + rectangle));
        this.drawSkin(graphics, this.currentSkin, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (Screen screen : this.screens) {
            screen.paint(graphics);
        }
    }

    public void addRotationListener(VMRotationListener vMRotationListener) {
        for (Screen screen : this.screens) {
            screen.addRotationListener(vMRotationListener);
        }
    }

    public Orientation getOrientation() {
        return this.rotation;
    }

    public Object getPrimaryScreen() {
        return this.screens.get(0);
    }

    public void setRotation(Orientation orientation) {
        Object object;
        this.rotation = orientation;
        int n = this.defaultSkin.getWidth();
        int n2 = this.defaultSkin.getHeight();
        RotateTranslator rotateTranslator = new RotateTranslator(orientation, n, n2);
        double d = 0.0;
        int n3 = 0;
        int n4 = 0;
        switch (orientation) {
            case NORMAL: {
                this.defaultSkinRotated = this.defaultSkin;
                this.highlightedSkinRotated = this.highlightedSkin;
                this.pressedSkinRotated = this.pressedSkin;
                break;
            }
            case RIGHT: {
                d = 1.5707963267948966;
                n3 = n2;
                break;
            }
            case LEFT: {
                d = -1.5707963267948966;
                n4 = n;
                break;
            }
            case UPSIDE_DOWN: {
                d = Math.PI;
                n3 = n;
                n4 = n2;
            }
        }
        if (d != 0.0) {
            object = new AffineTransform();
            ((AffineTransform)object).translate(n3, n4);
            ((AffineTransform)object).rotate(d);
            AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, 2);
            if (orientation == Orientation.LEFT || orientation == Orientation.RIGHT) {
                this.defaultSkinRotated = new BufferedImage(n2, n, this.defaultSkin.getType());
                this.highlightedSkinRotated = new BufferedImage(n2, n, this.highlightedSkin.getType());
                this.pressedSkinRotated = new BufferedImage(n2, n, this.pressedSkin.getType());
            } else {
                this.defaultSkinRotated = new BufferedImage(n, n2, this.defaultSkin.getType());
                this.highlightedSkinRotated = new BufferedImage(n, n2, this.highlightedSkin.getType());
                this.pressedSkinRotated = new BufferedImage(n, n2, this.pressedSkin.getType());
            }
            affineTransformOp.filter(this.defaultSkin, this.defaultSkinRotated);
            affineTransformOp.filter(this.highlightedSkin, this.highlightedSkinRotated);
            affineTransformOp.filter(this.pressedSkin, this.pressedSkinRotated);
        }
        if (this.networkIndicator != null) {
            object = rotateTranslator.translateRect(this.originalNetworkIndicatorBounds);
            this.networkIndicator.rotate((Rectangle)object, orientation);
        }
        this.currentSkin = this.defaultSkinRotated;
        this.repositionControls((PositionTranslator)rotateTranslator);
        for (Screen screen : this.screens) {
            screen.reposition((PositionTranslator)rotateTranslator, orientation);
        }
        this.initBounds();
    }

    abstract void repositionControls(PositionTranslator var1);

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.defaultSkinRotated.getWidth() * this.scale, this.defaultSkinRotated.getHeight() * this.scale);
    }

    void repaintNow(int n, int n2, int n3, int n4) {
        this.device.repaint(n, n2, n3, n4);
    }

    public void setNetworkIndicatorVisibility(boolean bl) {
        if (this.networkIndicator != null) {
            LOGGER.debug((Object)("Set NetworkIndicator visibility to " + bl));
            this.networkIndicator.setVisible(bl);
            this.networkIndicator.repaint();
        }
    }

    public void setBacklight(boolean bl) {
        this.currentSkin = bl ? this.highlightedSkinRotated : this.defaultSkinRotated;
        this.repaintNow(0, 0, this.defaultSkinRotated.getWidth() * this.scale, this.defaultSkinRotated.getHeight() * this.scale);
    }

    public void repaintNow(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.repaint(rectangle.x * this.scale, rectangle.y * this.scale, rectangle.width * this.scale, rectangle.height * this.scale);
        } else if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            int[] nArray3 = new int[nArray.length];
            int[] nArray4 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray3[i] = nArray[i] * this.scale;
                nArray4[i] = nArray2[i] * this.scale;
            }
            this.repaint(new Polygon(nArray3, nArray4, nArray.length).getBounds());
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        for (Screen screen : this.screens) {
            screen.setVisible(bl);
        }
        if (this.networkIndicator != null) {
            this.networkIndicator.setVisible(bl);
        }
    }

    public void buttonPressed(Object object) {
        int n = this.buttonListeners.size();
        LOGGER.debug((Object)("Notifying " + n + " ButtonListeners about buttonPressed event"));
        for (int i = 0; i < n; ++i) {
            ButtonsListener buttonsListener = this.buttonListeners.get(i);
            buttonsListener.buttonPressed(object);
        }
    }

    public void buttonReleased(Object object) {
        int n = this.buttonListeners.size();
        LOGGER.debug((Object)("Notifying " + n + " ButtonListeners about buttonReleased event"));
        for (int i = 0; i < n; ++i) {
            ButtonsListener buttonsListener = this.buttonListeners.get(i);
            buttonsListener.buttonReleased(object);
        }
    }

    public void activateInputState(int n) {
        LOGGER.debug((Object)("Activating input state " + n));
        this.inputStates[n - 1] = true;
    }

    public void deactivateInputState(int n) {
        LOGGER.debug((Object)("Deactivating input state " + n));
        this.inputStates[n - 1] = false;
    }

    public int getInputState() {
        for (int i = this.inputStateCount - 1; i >= 0; --i) {
            if (!this.inputStates[i]) continue;
            LOGGER.debug((Object)("Current input state is " + (i + 1)));
            return i + 1;
        }
        LOGGER.debug((Object)"Current input state is 0");
        return 0;
    }

    public void setInputStateCount(int n) {
        this.inputStateCount = n;
    }

    public abstract void addControl(DeviceInput var1);

    public Screen[] getScreens() {
        return this.screens.toArray(new Screen[0]);
    }
}

