/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.ButtonSoundImpl;
import com.sun.kvem.Device;
import com.sun.kvem.DeviceInput;
import com.sun.kvem.DeviceStateSpi;
import com.sun.kvem.KeyEventHelper;
import com.sun.kvem.PositionTranslator;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class Button
implements DeviceInput {
    private static final Logger LOGGER = Logger.getLogger(Button.class);
    private static final int STATE_DEFAULT = 0;
    private static final int STATE_HIGHLIGHTED = 1;
    private static final int STATE_ARMED_MOUSE = 2;
    private static final int STATE_ARMED_KEY = 3;
    private static final int scale = Device.getIntegerProperty((String)"scale", (int)1);
    private ButtonSoundImpl beep;
    private Properties properties;
    protected String name;
    private int[] originalPosition;
    private static boolean activeStickyButton = false;
    protected ButtonState state = ButtonState.DEFAULT;
    private ButtonState[] states = ButtonState.regularStates;
    private boolean pointerInRegion;
    protected Shape activeRegion;
    protected DeviceStateSpi deviceState;
    protected int[] keyTriggers;
    protected boolean sticky;
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    public void setName(String string) {
        this.name = string;
    }

    void setState(int n) {
        LOGGER.debug((Object)("Setting state of " + this.name + " to " + n));
        this.setState(this.states[n]);
    }

    static int parseActivatorKeyCode(String string) throws IllegalArgumentException {
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Button.getDefaultActivatorKeyCode(string);
        }
    }

    static int getDefaultActivatorKeyCode(String string) {
        return KeyEventHelper.getCode((String)string);
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setDeviceState(DeviceStateSpi deviceStateSpi) {
        this.deviceState = deviceStateSpi;
    }

    public void setRegion(int[] nArray) {
        this.originalPosition = nArray;
        this.updateActiveRegion(nArray);
    }

    private void updateActiveRegion(int[] nArray) {
        if (nArray.length == 4) {
            this.activeRegion = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        } else if (nArray.length > 4 && nArray.length % 2 == 0) {
            int[] nArray2 = new int[nArray.length / 2];
            int[] nArray3 = new int[nArray.length / 2];
            int n = nArray.length / 2;
            for (int i = 0; i < nArray.length; i += 2) {
                nArray2[i / 2] = nArray[i];
                nArray3[i / 2] = nArray[i + 1];
            }
            this.activeRegion = new Polygon(nArray2, nArray3, n);
        } else {
            throw new IllegalArgumentException("Incorrect number of entries in button coordinates: " + nArray.length);
        }
    }

    private void keyPressed(InputEvent inputEvent) {
        LOGGER.trace((Object)("Input event accepted by " + this));
        this.handleKeyPressed(inputEvent);
        this.deviceState.buttonPressed((Object)this);
        this.beep("press");
    }

    protected abstract void handleKeyPressed(InputEvent var1);

    private void keyReleased(InputEvent inputEvent) {
        LOGGER.trace((Object)("Input event accepted by " + this));
        this.handleKeyReleased(inputEvent);
        this.deviceState.buttonReleased((Object)this);
        this.beep("release");
    }

    protected abstract void handleKeyReleased(InputEvent var1);

    private void beep(String string) {
        if (this.properties == null) {
            return;
        }
        if (this.beep == null) {
            this.beep = new ButtonSoundImpl(this.name, this.properties);
        }
        this.beep.play(string);
    }

    private void setState(ButtonState buttonState) {
        this.state = buttonState;
        this.repaint();
    }

    private void setStates(ButtonState[] buttonStateArray) {
        this.states = buttonStateArray;
    }

    private ButtonState[] getStates() {
        return this.states;
    }

    private void setActiveStickyButton(boolean bl) {
        activeStickyButton = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        this.state.paint(this, graphics);
    }

    private void repaint() {
        this.deviceState.repaintNow(this.activeRegion);
    }

    @Override
    public Cursor getActiveCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public boolean accept(KeyEvent keyEvent) {
        return keyEvent.getModifiers() == 0 && this.state.accept(this, keyEvent);
    }

    @Override
    public boolean accept(MouseEvent mouseEvent, int n, int n2) {
        this.pointerInRegion = this.activeRegion.contains(n, n2);
        return this.state.accept(this, mouseEvent);
    }

    static String rect(Rectangle rectangle) {
        return "(" + rectangle.x + ", " + rectangle.y + ")" + ", " + rectangle.width + "x" + rectangle.height;
    }

    @Override
    public void reposition(PositionTranslator positionTranslator) {
        if (this.originalPosition == null) {
            this.create();
        }
        if (this.originalPosition.length % 2 != 0) {
            return;
        }
        int[] nArray = new int[this.originalPosition.length];
        if (this.originalPosition.length == 4) {
            Rectangle rectangle = positionTranslator.translateRect(new Rectangle(this.originalPosition[0], this.originalPosition[1], this.originalPosition[2], this.originalPosition[3]));
            nArray[0] = rectangle.x;
            nArray[1] = rectangle.y;
            nArray[2] = rectangle.width;
            nArray[3] = rectangle.height;
        } else {
            for (int i = 0; i < this.originalPosition.length; i += 2) {
                Point point = positionTranslator.translatePoint(new Point(this.originalPosition[i], this.originalPosition[i + 1]));
                nArray[i] = point.x;
                nArray[i + 1] = point.y;
            }
        }
        this.updateActiveRegion(nArray);
    }

    public boolean hasKeyTriggers() {
        return this.keyTriggers != null;
    }

    void addKeyCodeTrigger(int n) {
        LOGGER.debug((Object)("Adding trigger for key code " + n));
        this.keyTriggers = Button.addInt(this.keyTriggers, n);
    }

    private static int[] addInt(int[] nArray, int n) {
        if (nArray == null) {
            return new int[]{n};
        }
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return nArray;
        }
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n;
        return nArray2;
    }

    protected boolean triggeredBy(int n) {
        return Button.containsTrigger(this.keyTriggers, n);
    }

    private static boolean containsTrigger(int[] nArray, int n) {
        if (nArray != null) {
            for (int n2 : nArray) {
                if (n2 != n) continue;
                return true;
            }
        }
        return false;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void create() {
        if (this.activeRegion == null) {
            this.originalPosition = new int[]{this.x, this.y, this.width, this.height};
            this.activeRegion = new Rectangle(this.x, this.y, this.width, this.height);
        }
    }

    private static class ArmedKeyState
    extends ArmedState {
        private ArmedKeyState() {
        }

        @Override
        public boolean accept(Button button, MouseEvent mouseEvent) {
            return false;
        }

        @Override
        public boolean accept(Button button, KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.getID() == 402) {
                if (button.triggeredBy(n)) {
                    LOGGER.trace((Object)"This button reacts on this KEY_RELEASED event");
                    button.keyReleased(keyEvent);
                    if (button.pointerInRegion) {
                        button.setState(button.states[1]);
                    } else {
                        button.setState(button.states[0]);
                    }
                    return true;
                }
            } else if (keyEvent.getID() == 401 && button.triggeredBy(n)) {
                return true;
            }
            return false;
        }
    }

    private static class ArmedMouseState
    extends ArmedState {
        private ArmedMouseState() {
        }

        @Override
        public boolean accept(Button button, MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 502: {
                    if (button.getStates() == stickyStates) {
                        return false;
                    }
                    button.keyReleased(mouseEvent);
                    if (button.pointerInRegion) {
                        button.setState(button.states[1]);
                    } else {
                        button.setState(button.states[0]);
                    }
                    return true;
                }
                case 503: 
                case 506: {
                    if (button.getStates() == stickyStates) {
                        return true;
                    }
                    if (button.pointerInRegion) break;
                    button.keyReleased(mouseEvent);
                    button.setState(button.states[0]);
                    return true;
                }
                case 501: {
                    if (!button.pointerInRegion) break;
                    button.keyPressed(mouseEvent);
                    button.setStates(ArmedMouseState.regularStates);
                    button.setActiveStickyButton(false);
                    button.setState(button.states[2]);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean accept(Button button, KeyEvent keyEvent) {
            return false;
        }
    }

    static abstract class ArmedState
    implements ButtonState {
        ArmedState() {
        }

        @Override
        public void paint(Button button, Graphics graphics) {
            graphics = graphics.create();
            Rectangle rectangle = button.activeRegion.getBounds();
            if (button.activeRegion instanceof Rectangle) {
                Rectangle rectangle2 = (Rectangle)button.activeRegion;
                graphics.setClip(rectangle2.x * scale, rectangle2.y * scale, rectangle2.width * scale, rectangle2.height * scale);
            } else if (button.activeRegion instanceof Polygon) {
                Polygon polygon = (Polygon)button.activeRegion;
                int[] nArray = polygon.xpoints;
                int[] nArray2 = polygon.ypoints;
                int[] nArray3 = new int[nArray.length];
                int[] nArray4 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray3[i] = nArray[i] * scale;
                    nArray4[i] = nArray2[i] * scale;
                }
                graphics.setClip(new Polygon(nArray3, nArray4, nArray.length));
            }
            graphics.drawImage(button.deviceState.getPressedImage(), rectangle.x * scale, rectangle.y * scale, (rectangle.width + rectangle.x) * scale, (rectangle.height + rectangle.y) * scale, rectangle.x, rectangle.y, rectangle.width + rectangle.x, rectangle.height + rectangle.y, null);
        }

        public String toString() {
            return "ButtonState.ARMED";
        }
    }

    private static class HighlightedButtonState
    implements ButtonState {
        private HighlightedButtonState() {
        }

        @Override
        public boolean accept(Button button, MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 501: {
                    return DEFAULT.accept(button, mouseEvent);
                }
                case 503: {
                    if (button.pointerInRegion) break;
                    button.setState(button.states[0]);
                }
            }
            return false;
        }

        @Override
        public boolean accept(Button button, KeyEvent keyEvent) {
            return DEFAULT.accept(button, keyEvent);
        }

        @Override
        public void paint(Button button, Graphics graphics) {
            graphics = graphics.create();
            Rectangle rectangle = button.activeRegion.getBounds();
            if (button.activeRegion instanceof Rectangle) {
                Rectangle rectangle2 = (Rectangle)button.activeRegion;
                graphics.setClip(rectangle2.x * scale, rectangle2.y * scale, rectangle2.width * scale, rectangle2.height * scale);
            } else if (button.activeRegion instanceof Polygon) {
                Polygon polygon = (Polygon)button.activeRegion;
                int[] nArray = polygon.xpoints;
                int[] nArray2 = polygon.ypoints;
                int[] nArray3 = new int[nArray.length];
                int[] nArray4 = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray3[i] = nArray[i] * scale;
                    nArray4[i] = nArray2[i] * scale;
                }
                graphics.setClip(new Polygon(nArray3, nArray4, nArray.length));
            }
            graphics.drawImage(button.deviceState.getHighlightedImage(), rectangle.x * scale, rectangle.y * scale, (rectangle.width + rectangle.x) * scale, (rectangle.height + rectangle.y) * scale, rectangle.x, rectangle.y, rectangle.width + rectangle.x, rectangle.height + rectangle.y, null);
        }

        public String toString() {
            return "ButtonState.HIGHLIGHT";
        }
    }

    private static class DefaultButtonState
    implements ButtonState {
        private DefaultButtonState() {
        }

        @Override
        public boolean accept(Button button, KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.getID() == 401 && button.triggeredBy(n)) {
                LOGGER.trace((Object)"This button reacts on this KEY_PRESSED event");
                button.keyPressed(keyEvent);
                button.setState(button.states[3]);
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(Button button, MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!button.pointerInRegion) break;
                    if (button.sticky) {
                        if (activeStickyButton) {
                            return false;
                        }
                        button.setStates(DefaultButtonState.stickyStates);
                        button.setActiveStickyButton(true);
                    }
                    button.keyPressed(mouseEvent);
                    button.setState(button.states[2]);
                    return true;
                }
                case 503: {
                    if (!button.pointerInRegion) break;
                    button.setState(1);
                }
            }
            return false;
        }

        @Override
        public void paint(Button button, Graphics graphics) {
        }

        public String toString() {
            return "ButtonState.DEFAULT";
        }
    }

    private static interface ButtonState {
        public static final ButtonState DEFAULT = new DefaultButtonState();
        public static final ButtonState HIGHLIGHTED = new HighlightedButtonState();
        public static final ButtonState ARMED_MOUSE = new ArmedMouseState();
        public static final ButtonState ARMED_KEY = new ArmedKeyState();
        public static final ButtonState[] regularStates = new ButtonState[]{DEFAULT, HIGHLIGHTED, ARMED_MOUSE, ARMED_KEY};
        public static final ButtonState[] stickyStates = new ButtonState[]{ARMED_MOUSE, ARMED_MOUSE, ARMED_MOUSE, ARMED_MOUSE};

        public boolean accept(Button var1, KeyEvent var2);

        public boolean accept(Button var1, MouseEvent var2);

        public void paint(Button var1, Graphics var2);
    }
}

