/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.jme.toolkit.ui.util.Action;
import com.sun.jme.toolkit.ui.util.Menu;
import com.sun.kvem.DeviceStateSpi;
import com.sun.kvem.EMDevice;
import com.sun.kvem.EmulatorRotationListener;
import com.sun.kvem.EmulatorStateListener;
import com.sun.kvem.Orientation;
import com.sun.kvem.OrientationSupport;
import com.sun.kvem.SupportedOrientations;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class DeviceOrientationMenu
extends Menu
implements EmulatorStateListener,
EmulatorRotationListener {
    private OrientationSupport orientationSupport;
    private EMDevice device;
    private ButtonGroup buttonGroup;
    private EventManagerSpi eventManager;
    private Map<Orientation, JRadioButtonMenuItem> items;
    private Orientation currentOrientation = Orientation.NORMAL;
    private String rotateClockwiseText = "Rotate clockwise";
    private String rotateCounterclockwiseText = "Rotate counterclockwise";
    private String rotateClockwiseAccel = "F8";
    private String rotateCounterclockwiseAccel = "F9";

    public void setOrientationSupport(OrientationSupport orientationSupport) {
        this.orientationSupport = orientationSupport;
    }

    public void setDevice(EMDevice eMDevice) {
        this.device = eMDevice;
    }

    public void setEventManager(EventManagerSpi eventManagerSpi) {
        this.eventManager = eventManagerSpi;
    }

    public void setRotateClockwiseAccelerator(String string) {
        this.rotateClockwiseAccel = string;
    }

    public void setRotateClockwiseText(String string) {
        this.rotateClockwiseText = string;
    }

    public void setRotateCounterclockwiseAccelerator(String string) {
        this.rotateCounterclockwiseAccel = string;
    }

    public void setRotateCounterclockwiseText(String string) {
        this.rotateCounterclockwiseText = string;
    }

    public void setInitialOrientation(Orientation orientation) {
        this.currentOrientation = orientation;
    }

    public void create() {
        this.items = new HashMap<Orientation, JRadioButtonMenuItem>();
        this.buttonGroup = new ButtonGroup();
        Orientation orientation = Orientation.NORMAL;
        for (Orientation object2 : Orientation.values()) {
            this.createMenuFor(object2, orientation == object2);
        }
        this.add(new JPopupMenu.Separator());
        ShiftOrientationAction shiftOrientationAction = new ShiftOrientationAction();
        shiftOrientationAction.setActionName(this.rotateClockwiseText);
        shiftOrientationAction.setAccelerator(this.rotateClockwiseAccel);
        shiftOrientationAction.setClockwise(true);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction((javax.swing.Action)((Object)shiftOrientationAction));
        this.add(jMenuItem);
        ShiftOrientationAction shiftOrientationAction2 = new ShiftOrientationAction();
        shiftOrientationAction2.setActionName(this.rotateCounterclockwiseText);
        shiftOrientationAction2.setAccelerator(this.rotateCounterclockwiseAccel);
        shiftOrientationAction2.setClockwise(false);
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setAction((javax.swing.Action)((Object)shiftOrientationAction2));
        this.add(jMenuItem2);
        if (!this.device.supportsRotation()) {
            jMenuItem.setEnabled(false);
            jMenuItem2.setEnabled(false);
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.items.values()) {
                jRadioButtonMenuItem.setEnabled(false);
            }
        }
    }

    public void start() {
        if (this.device.supportsRotation()) {
            this.device.addStateListener(this);
            this.device.addRotationListener(this);
            this.notifyStateChanged(this.device.getInitialState());
            if (this.currentOrientation != Orientation.NORMAL) {
                JRadioButtonMenuItem jRadioButtonMenuItem = this.items.get(this.currentOrientation);
                this.buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
                this.changeOrientation(this.currentOrientation);
            }
        }
    }

    private void createMenuFor(Orientation orientation, boolean bl) {
        SwitchOrientationAction switchOrientationAction = new SwitchOrientationAction();
        switchOrientationAction.setOrientation(orientation);
        switchOrientationAction.setActionName(orientation.toAngle() + "\u00b0");
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((javax.swing.Action)((Object)switchOrientationAction));
        jRadioButtonMenuItem.setSelected(bl);
        this.add(jRadioButtonMenuItem);
        this.buttonGroup.add(jRadioButtonMenuItem);
        this.items.put(orientation, jRadioButtonMenuItem);
    }

    public void notifyStateChanged(DeviceStateSpi deviceStateSpi) {
        SupportedOrientations supportedOrientations = deviceStateSpi.getSupportedOrientations();
        for (Orientation orientation : Orientation.values()) {
            this.items.get(orientation).setEnabled(supportedOrientations.contains(orientation));
        }
        if (!supportedOrientations.contains(this.currentOrientation)) {
            Orientation orientation = this.currentOrientation.rotateClockwise();
            if (!supportedOrientations.contains(orientation)) {
                orientation = this.currentOrientation.rotateCounterclockwise();
            }
            if (!supportedOrientations.contains(orientation)) {
                orientation = this.currentOrientation.rotateClockwise();
                orientation = orientation.rotateClockwise();
            }
            JRadioButtonMenuItem jRadioButtonMenuItem = this.items.get(orientation);
            jRadioButtonMenuItem.getAction().actionPerformed(null);
            this.buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
    }

    public void notifyRotationChanged(Orientation orientation) {
        if (orientation != this.currentOrientation) {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.items.get(orientation);
            this.buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
            this.currentOrientation = orientation;
        }
    }

    private void changeOrientation(Orientation orientation) {
        this.orientationSupport.setRequestedOrientation(orientation);
        this.eventManager.injectRotateEvent(orientation.toMidpOrientation());
    }

    private class ShiftOrientationAction
    extends Action {
        private boolean clockwise = true;

        private ShiftOrientationAction() {
        }

        public void setClockwise(boolean bl) {
            this.clockwise = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            Orientation orientation = DeviceOrientationMenu.this.currentOrientation;
            do {
                orientation = this.clockwise ? orientation.rotateClockwise() : orientation.rotateCounterclockwise();
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)DeviceOrientationMenu.this.items.get(orientation);
                bl = jRadioButtonMenuItem.isEnabled();
                if (!bl) continue;
                jRadioButtonMenuItem.getAction().actionPerformed(actionEvent);
                DeviceOrientationMenu.this.buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
            } while (!bl);
        }
    }

    private class SwitchOrientationAction
    extends Action {
        private Orientation orientation;

        private SwitchOrientationAction() {
        }

        public void setOrientation(Orientation orientation) {
            this.orientation = orientation;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DeviceOrientationMenu.this.device.setOrientation(this.orientation);
            DeviceOrientationMenu.this.changeOrientation(this.orientation);
            DeviceOrientationMenu.this.currentOrientation = this.orientation;
        }
    }
}

