/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.jme.toolkit.ui.util.Action;
import com.sun.jme.toolkit.ui.util.Menu;
import com.sun.kvem.EMDevice;
import com.sun.kvem.EMDeviceState;
import com.sun.kvem.SwitchDeviceStateAction;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class DeviceStateMenu
extends Menu {
    private EMDevice device;
    private ButtonGroup buttonGroup;
    private EventManagerSpi eventManager;
    private Map<EMDeviceState, JRadioButtonMenuItem> items;
    private String switchStateText = "Switch state";
    private String switchStateAccelerator = "F11";

    public void setDevice(EMDevice eMDevice) {
        this.device = eMDevice;
    }

    public void setEventManager(EventManagerSpi eventManagerSpi) {
        this.eventManager = eventManagerSpi;
    }

    public void setSwitchStateAccelerator(String string) {
        this.switchStateAccelerator = string;
    }

    public void setSwitchStateText(String string) {
        this.switchStateText = string;
    }

    public void create() {
        this.items = new HashMap<EMDeviceState, JRadioButtonMenuItem>();
        this.buttonGroup = new ButtonGroup();
        EMDeviceState eMDeviceState = this.device.getInitialState();
        for (EMDeviceState jComponent2 : this.device.deviceStates) {
            this.createMenuFor(jComponent2, eMDeviceState == jComponent2);
        }
        this.add(new JPopupMenu.Separator());
        Object object = new NextDeviceStateAction();
        object.setActionName(this.switchStateText);
        object.setAccelerator(this.switchStateAccelerator);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction((javax.swing.Action)object);
        this.add(jMenuItem);
    }

    private void createMenuFor(EMDeviceState eMDeviceState, boolean bl) {
        SwitchDeviceStateAction switchDeviceStateAction = new SwitchDeviceStateAction();
        switchDeviceStateAction.setDevice(this.device);
        switchDeviceStateAction.setState(eMDeviceState);
        switchDeviceStateAction.setEventManager(this.eventManager);
        switchDeviceStateAction.setActionName(eMDeviceState.getName());
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((javax.swing.Action)((Object)switchDeviceStateAction));
        jRadioButtonMenuItem.setSelected(bl);
        this.add(jRadioButtonMenuItem);
        this.buttonGroup.add(jRadioButtonMenuItem);
        this.items.put(eMDeviceState, jRadioButtonMenuItem);
    }

    private class NextDeviceStateAction
    extends Action {
        private NextDeviceStateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EMDeviceState eMDeviceState = DeviceStateMenu.this.device.nextDeviceState();
            DeviceStateMenu.this.eventManager.injectSwitchStateEvent(DeviceStateMenu.this.device.getDeviceStateIndex(eMDeviceState));
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)DeviceStateMenu.this.items.get(eMDeviceState);
            DeviceStateMenu.this.buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
    }
}

