/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.AbstractEMDevice;
import com.sun.kvem.BacklightSupport;
import com.sun.kvem.DeviceActivation;
import com.sun.kvem.DeviceStateSpi;
import com.sun.kvem.EMDeviceMBean;
import com.sun.kvem.EMDeviceState;
import com.sun.kvem.EmulatorRotationListener;
import com.sun.kvem.EmulatorStateListener;
import com.sun.kvem.KeyEventHandler;
import com.sun.kvem.Lime;
import com.sun.kvem.NetworkIndicatorSupport;
import com.sun.kvem.Orientation;
import com.sun.kvem.VMRotationListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class EMDevice
extends AbstractEMDevice
implements KeyListener,
NetworkIndicatorSupport,
BacklightSupport,
DeviceActivation,
VMRotationListener,
EMDeviceMBean {
    private Lime lime;
    private static final Logger LOGGER = Logger.getLogger(EMDevice.class);
    private boolean active;
    private boolean lastLightMode;
    private KeyEventHandler keyEventHandler;
    private boolean canRotate;
    protected Orientation rotation = Orientation.NORMAL;
    protected EMDeviceState deviceState;
    protected EMDeviceState initialState;
    protected List<EMDeviceState> deviceStates = new ArrayList<EMDeviceState>();
    protected List<EmulatorRotationListener> rotationListeners = new ArrayList<EmulatorRotationListener>();
    protected List<EmulatorStateListener> stateListeners = new ArrayList<EmulatorStateListener>();
    protected boolean lastNetworkIndicatorMode = false;

    public void addDeviceState(EMDeviceState eMDeviceState) {
        this.deviceStates.add(eMDeviceState);
        this.add(eMDeviceState);
    }

    public void setInitialState(EMDeviceState eMDeviceState) {
        this.initialState = eMDeviceState;
    }

    public void setLime(Lime lime) {
        this.lime = lime;
    }

    public void setKeyEventHandler(KeyEventHandler keyEventHandler) {
        this.keyEventHandler = keyEventHandler;
    }

    public boolean supportsRotation() {
        return this.canRotate;
    }

    public void setSupportsRotation(boolean bl) {
        this.canRotate = bl;
    }

    public void start() {
        this.deviceState = this.getInitialState();
        for (EMDeviceState eMDeviceState : this.deviceStates) {
            eMDeviceState.setVisible(false);
        }
        this.deviceState.setVisible(true);
        this.deviceState.setNetworkIndicatorVisibility(this.lastNetworkIndicatorMode);
        for (EMDeviceState eMDeviceState : this.deviceStates) {
            eMDeviceState.addRotationListener(this);
        }
        this.enableEvents(56L);
        if (this.canRotate) {
            this.rotationChanged();
        } else {
            this.rotation = Orientation.NORMAL;
        }
    }

    public EMDeviceState getInitialState() {
        return this.initialState == null ? this.deviceStates.get(0) : this.initialState;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.delegateMouseEvent(mouseEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.delegateMouseEvent(mouseEvent);
    }

    private void delegateMouseEvent(MouseEvent mouseEvent) {
        if (this.isActive()) {
            this.deviceState.handleMouseEvent(mouseEvent);
        }
    }

    public Dimension getPreferredSize() {
        return this.deviceState.getPreferredSize();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Key pressed: " + keyEvent));
        }
        if (this.filterKeyEvent(keyEvent)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Key press filtered: " + keyEvent));
            }
            return;
        }
        if (this.someControlAcceptedEvent(keyEvent)) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("None of device controls processed this event: " + keyEvent));
        }
        this.keyEventHandler.keyboardKeyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Key released: " + keyEvent));
        }
        if (this.filterKeyEvent(keyEvent)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Key release filtered: " + keyEvent));
            }
            return;
        }
        if (this.someControlAcceptedEvent(keyEvent)) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("None of device controls processed this event: " + keyEvent));
        }
        this.keyEventHandler.keyboardKeyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Key typed: " + keyEvent));
        }
        if (this.filterKeyEvent(keyEvent)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Key type filtered: " + keyEvent));
            }
            return;
        }
        if (this.someControlAcceptedEvent(keyEvent)) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("None of device controls processed this event: " + keyEvent));
        }
        this.keyEventHandler.keyboardKeyTyped(keyEvent);
    }

    private boolean someControlAcceptedEvent(KeyEvent keyEvent) {
        return this.deviceState.someControlAcceptedEvent(keyEvent);
    }

    private boolean filterKeyEvent(KeyEvent keyEvent) {
        return keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 27;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveWithLock(boolean bl) {
        Object object = this.lime.getLock();
        synchronized (object) {
            this.setActive(bl);
        }
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void setBacklight(boolean bl) {
        if (this.lastLightMode != bl) {
            this.lastLightMode = bl;
            this.deviceState.setBacklight(bl);
        }
    }

    public void setNetworkIndicator(int n) {
        boolean bl;
        boolean bl2 = bl = n > 1;
        if (bl != this.lastNetworkIndicatorMode) {
            this.lastNetworkIndicatorMode = bl;
            if (this.deviceState != null) {
                this.deviceState.setNetworkIndicatorVisibility(bl);
            }
        }
    }

    public EMDeviceState nextDeviceState() {
        int n = this.deviceStates.indexOf(this.deviceState) + 1;
        if (n >= this.deviceStates.size()) {
            n = 0;
        }
        EMDeviceState eMDeviceState = this.deviceStates.get(n);
        this.switchDeviceState(eMDeviceState);
        return eMDeviceState;
    }

    public void switchDeviceState(EMDeviceState eMDeviceState) {
        if (eMDeviceState == null || eMDeviceState == this.deviceState) {
            return;
        }
        this.deviceState.setVisible(false);
        this.deviceState.setNetworkIndicatorVisibility(false);
        this.deviceState = eMDeviceState;
        this.deviceState.setVisible(true);
        this.deviceState.setNetworkIndicatorVisibility(this.lastNetworkIndicatorMode);
        this.updateWindowSize();
        this.notifyStateListeners();
    }

    public void notifyRotationChanged(Object object, Orientation orientation) {
        if (this.rotation == orientation) {
            return;
        }
        this.setOrientation(orientation);
    }

    public void rotateClockwise() {
        this.setOrientation(this.rotation.rotateClockwise());
    }

    public void rotateCounterclockwise() {
        this.setOrientation(this.rotation.rotateCounterclockwise());
    }

    public void setOrientation(Orientation orientation) {
        if (this.canRotate) {
            this.rotation = orientation;
            this.rotationChanged();
        }
    }

    protected void rotationChanged() {
        for (EMDeviceState eMDeviceState : this.deviceStates) {
            eMDeviceState.setRotation(this.rotation);
        }
        this.updateWindowSize();
        this.repaint();
        this.notifyRotationListeners();
    }

    private void updateWindowSize() {
        Object object;
        for (object = this; object != null && !(object instanceof Window); object = ((Component)object).getParent()) {
        }
        Window window = (Window)object;
        if (window != null) {
            if ("Mac OS X".equals(System.getProperty("os.name"))) {
                window.setVisible(false);
                window.pack();
                window.setVisible(true);
            } else {
                window.pack();
            }
        }
    }

    public void setInitialOrientation(Orientation orientation) {
        this.rotation = orientation;
    }

    public Orientation getCurrentRotation() {
        return this.rotation;
    }

    public int getDeviceStateIndex(EMDeviceState eMDeviceState) {
        return this.deviceStates.indexOf(eMDeviceState);
    }

    public void addRotationListener(EmulatorRotationListener emulatorRotationListener) {
        this.rotationListeners.add(emulatorRotationListener);
    }

    public void removeRotationListener(EmulatorRotationListener emulatorRotationListener) {
        this.rotationListeners.remove(emulatorRotationListener);
    }

    private void notifyRotationListeners() {
        for (EmulatorRotationListener emulatorRotationListener : this.rotationListeners) {
            emulatorRotationListener.notifyRotationChanged(this.rotation);
        }
    }

    public void addStateListener(EmulatorStateListener emulatorStateListener) {
        this.stateListeners.add(emulatorStateListener);
    }

    public void removeStateListener(EmulatorStateListener emulatorStateListener) {
        this.stateListeners.remove(emulatorStateListener);
    }

    private void notifyStateListeners() {
        for (EmulatorStateListener emulatorStateListener : this.stateListeners) {
            emulatorStateListener.notifyStateChanged((DeviceStateSpi)this.deviceState);
        }
    }

    public Object getPrimaryScreen() {
        return this.getInitialState().getScreens()[0];
    }
}

