/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.AbstractEMDeviceState;
import com.sun.kvem.DeviceInput;
import com.sun.kvem.EMDeviceStateMBean;
import com.sun.kvem.InputAwareControl;
import com.sun.kvem.PositionTranslator;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EMDeviceState
extends AbstractEMDeviceState
implements EMDeviceStateMBean {
    private static final Logger LOGGER = Logger.getLogger(AbstractEMDeviceState.class);
    protected ArrayList<DeviceInput> controls = new ArrayList();

    public void addControls(DeviceInput[] deviceInputArray) {
        for (DeviceInput deviceInput : deviceInputArray) {
            this.controls.add(deviceInput);
        }
    }

    public void addInputAwareControl(InputAwareControl inputAwareControl) {
        this.addControl(inputAwareControl);
        this.buttonListeners.add(inputAwareControl);
    }

    @Override
    public void addControl(DeviceInput deviceInput) {
        this.controls.add(deviceInput);
    }

    void handleMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (DeviceInput deviceInput : this.controls) {
            if (deviceInput.accept(mouseEvent, n / this.scale, n2 / this.scale)) break;
        }
    }

    boolean someControlAcceptedEvent(KeyEvent keyEvent) {
        for (DeviceInput deviceInput : this.controls) {
            if (!deviceInput.accept(keyEvent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        LOGGER.debug((Object)"Redrawing input controls");
        for (DeviceInput deviceInput : this.controls) {
            deviceInput.paint(graphics);
        }
    }

    @Override
    void repositionControls(PositionTranslator positionTranslator) {
        for (DeviceInput deviceInput : this.controls) {
            deviceInput.reposition(positionTranslator);
        }
    }
}

