/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Orientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private BufferedImage image;
    private BufferedImage rotatedImage;

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.rotatedImage = bufferedImage;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.rotatedImage.getWidth(null), this.rotatedImage.getHeight(null));
    }

    public void rotate(Rectangle rectangle, Orientation orientation) {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        double d = 0.0;
        int n3 = 0;
        int n4 = 0;
        switch (orientation) {
            case NORMAL: {
                this.rotatedImage = this.image;
                break;
            }
            case RIGHT: {
                d = 1.5707963267948966;
                n3 = n2;
                break;
            }
            case LEFT: {
                d = -1.5707963267948966;
                n4 = n;
                break;
            }
            case UPSIDE_DOWN: {
                d = Math.PI;
                n3 = n;
                n4 = n2;
            }
        }
        if (d != 0.0) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n3, n4);
            affineTransform.rotate(d);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            this.rotatedImage = new BufferedImage(rectangle.width, rectangle.height, this.image.getType());
            affineTransformOp.filter(this.image, this.rotatedImage);
        }
        this.setBounds(rectangle);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(this.rotatedImage, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight(), null);
    }
}

