/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.jme.emulator.events.spi.EventManagerSpi;
import com.sun.kvem.DeviceInput;
import com.sun.kvem.PositionTranslator;
import com.sun.kvem.Screen;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class ScreenDevice
implements DeviceInput {
    private static final Logger LOGGER = Logger.getLogger(ScreenDevice.class);
    private boolean eventOnMouseMove;
    private transient boolean dragging;
    private EventManagerSpi eventManager;
    private Screen screen;

    public void setEventOnMouseMove(boolean bl) {
        this.eventOnMouseMove = bl;
    }

    public void setEventManager(EventManagerSpi eventManagerSpi) {
        this.eventManager = eventManagerSpi;
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    @Override
    public boolean accept(MouseEvent mouseEvent, int n, int n2) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Processing mouse event at " + n + ':' + n2));
        }
        if (!this.dragging && !this.screen.isIn(n, n2)) {
            return false;
        }
        Point point = this.screen.getNearestLocationInScreen(n, n2);
        int n3 = point.x;
        int n4 = point.y;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Translated mouse event to " + n3 + ':' + n4));
        }
        switch (mouseEvent.getID()) {
            case 503: {
                if (!this.eventOnMouseMove) {
                    return false;
                }
            }
            case 506: {
                this.eventManager.penMove(n3, n4, mouseEvent);
                return true;
            }
            case 501: {
                this.dragging = true;
                this.eventManager.penDown(n3, n4, mouseEvent);
                return true;
            }
            case 502: {
                this.dragging = false;
                this.eventManager.penUp(n3, n4, mouseEvent);
                return true;
            }
        }
        return false;
    }

    @Override
    public void reposition(PositionTranslator positionTranslator) {
    }

    @Override
    public boolean accept(KeyEvent keyEvent) {
        return false;
    }

    @Override
    public Cursor getActiveCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public void paint(Graphics graphics) {
    }
}

