/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.environment.DevicePropertyManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import org.apache.log4j.Logger;

public class SoundFile {
    private static final Logger LOGGER = Logger.getLogger(SoundFile.class);
    private Object thisSound;
    private boolean midiEOM;
    private static boolean audioLineAvailable = true;

    public SoundFile(String string) {
        AutoCloseable autoCloseable;
        Object object;
        URL uRL = DevicePropertyManager.getResource((Properties)Device.getProperties(), (String)string);
        try {
            this.thisSound = AudioSystem.getAudioInputStream(uRL);
            LOGGER.debug((Object)("Sound: Loaded sampled file " + uRL.toExternalForm()));
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)("Sound " + uRL.toExternalForm() + " does not exist"));
            this.thisSound = this.getDefaultSound();
        }
        catch (Exception exception) {
            try {
                object = uRL.openStream();
                this.thisSound = new BufferedInputStream((InputStream)object, 1024);
                LOGGER.debug((Object)("Sound: [" + exception + "] loaded BufferedInputStream file"));
            }
            catch (Exception exception2) {
                LOGGER.warn((Object)("'" + string + "' is not valid sound file"));
                this.thisSound = this.getDefaultSound();
                return;
            }
        }
        if (this.thisSound instanceof AudioInputStream) {
            try {
                Object object2;
                autoCloseable = (AudioInputStream)this.thisSound;
                object = ((AudioInputStream)autoCloseable).getFormat();
                if (((AudioFormat)object).getEncoding() == AudioFormat.Encoding.ULAW || ((AudioFormat)object).getEncoding() == AudioFormat.Encoding.ALAW) {
                    object2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object).getSampleRate(), ((AudioFormat)object).getSampleSizeInBits() * 2, ((AudioFormat)object).getChannels(), ((AudioFormat)object).getFrameSize() * 2, ((AudioFormat)object).getFrameRate(), true);
                    autoCloseable = AudioSystem.getAudioInputStream((AudioFormat)object2, (AudioInputStream)autoCloseable);
                    object = object2;
                }
                object2 = new DataLine.Info(Clip.class, ((AudioInputStream)autoCloseable).getFormat(), (int)((AudioInputStream)autoCloseable).getFrameLength() * ((AudioFormat)object).getFrameSize());
                Clip clip = (Clip)AudioSystem.getLine((Line.Info)object2);
                clip.open((AudioInputStream)autoCloseable);
                this.thisSound = clip;
                audioLineAvailable = true;
            }
            catch (LineUnavailableException lineUnavailableException) {
                if (audioLineAvailable) {
                    LOGGER.debug((Object)"Cannot access audio system");
                    audioLineAvailable = false;
                }
                return;
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception, (Throwable)exception);
                this.thisSound = this.getDefaultSound();
                return;
            }
        }
        if (this.thisSound instanceof Sequence || this.thisSound instanceof BufferedInputStream) {
            try {
                autoCloseable = MidiSystem.getSequencer();
                autoCloseable.open();
                if (this.thisSound instanceof Sequence) {
                    autoCloseable.setSequence((Sequence)this.thisSound);
                } else {
                    autoCloseable.setSequence((BufferedInputStream)this.thisSound);
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                LOGGER.warn((Object)("'" + string + "' is not valid sound file"));
                this.thisSound = this.getDefaultSound();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.thisSound = this.getDefaultSound();
                return;
            }
            object = new MetaEventListener(){

                @Override
                public void meta(MetaMessage metaMessage) {
                    if (metaMessage.getType() == 47) {
                        SoundFile.this.midiEOM = true;
                    }
                }
            };
            autoCloseable.addMetaEventListener((MetaEventListener)object);
            this.thisSound = autoCloseable;
        }
    }

    public synchronized boolean play() {
        if (this.thisSound instanceof Sequencer) {
            return this.playMidi();
        }
        if (this.thisSound instanceof Clip) {
            return this.playSampled();
        }
        return false;
    }

    public void playAsynch() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SoundFile.this.play();
            }
        }).start();
    }

    private boolean playMidi() {
        if (this.thisSound instanceof Sequencer) {
            Sequencer sequencer = (Sequencer)this.thisSound;
            this.midiEOM = false;
            sequencer.start();
            while (!this.midiEOM) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            sequencer.stop();
            sequencer.setMicrosecondPosition(0L);
            return true;
        }
        return false;
    }

    private boolean playSampled() {
        if (this.thisSound instanceof Clip) {
            Clip clip = (Clip)this.thisSound;
            clip.start();
            try {
                Thread.sleep(99L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (clip.isActive()) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            clip.stop();
            clip.setFramePosition(0);
            return true;
        }
        return false;
    }

    private Object getDefaultSound() {
        return null;
    }

    public void close() {
        AutoCloseable autoCloseable;
        if (this.thisSound == null) {
            return;
        }
        if (this.thisSound instanceof Clip && (autoCloseable = (Clip)this.thisSound).isOpen()) {
            autoCloseable.close();
        }
        if (this.thisSound instanceof Sequencer && (autoCloseable = (Sequencer)this.thisSound).isOpen()) {
            autoCloseable.close();
        }
    }
}

