/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.util.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public final void writeChar(char c) throws IOException {
        this.out.write(c >>> 0 & 0xFF);
        this.out.write(c >>> 8 & 0xFF);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeByte(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeShort(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChar(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.out.write(n >>> 0 & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 24 & 0xFF);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeString(String string, int n) throws IOException {
        int n2;
        int n3 = Math.min(string.length(), n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.writeChar(string.charAt(n2));
        }
        for (n2 = 0; n2 < n - n3; ++n2) {
            this.writeChar('\u0000');
        }
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.write((byte)(l >>> 0));
        this.write((byte)(l >>> 8));
        this.write((byte)(l >>> 16));
        this.write((byte)(l >>> 24));
        this.write((byte)(l >>> 32));
        this.write((byte)(l >>> 40));
        this.write((byte)(l >>> 48));
        this.write((byte)(l >>> 56));
    }
}

