/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.bridge.profiler;

import com.sun.jme.remoting.CommException;
import com.sun.jme.services.profiler.ProfilerObserver;
import com.sun.jme.services.profiler.ProfilerRecord;
import com.sun.jme.services.profiler.ProfilerRecordBuffer;
import com.sun.jme.services.profiler.ProfilerRecordStream;
import com.sun.jme.services.profiler.ProfilerService;
import com.sun.jme.toolkit.bridge.profiler.ProfilerAdapterMBean;
import com.sun.jme.toolkit.device.profiler.api.ProfileDataListener;
import com.sun.jme.toolkit.device.profiler.api.ProfileDataRecord;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProfilerAdapter
implements ProfilerAdapterMBean {
    private static final Logger LOGGER = Logger.getLogger(ProfilerAdapter.class);
    private final ProfilerService profilerJmeService;
    private Map<Integer, ProfilerStreamAdapter> streamAdapters;
    private Map<ProfileDataListener, ProfilerListenerAdapter> listenerAdapters;
    private int idCounter = 0;
    private int bufferSize;

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public ProfilerAdapter(ProfilerService profilerService) {
        this.profilerJmeService = profilerService;
        this.streamAdapters = new HashMap<Integer, ProfilerStreamAdapter>();
        this.listenerAdapters = new HashMap<ProfileDataListener, ProfilerListenerAdapter>();
    }

    public final void addProfileDataListener(ProfileDataListener profileDataListener) {
        ProfilerListenerAdapter profilerListenerAdapter = new ProfilerListenerAdapter(profileDataListener);
        try {
            this.profilerJmeService.addProfilerObserver((ProfilerObserver)profilerListenerAdapter);
            this.listenerAdapters.put(profileDataListener, profilerListenerAdapter);
        }
        catch (CommException commException) {
            LOGGER.error((Object)("Could not register profiler observer: " + (Object)((Object)commException)));
        }
    }

    public final void removeProfileDataListener(ProfileDataListener profileDataListener) {
        ProfilerListenerAdapter profilerListenerAdapter = this.listenerAdapters.get(profileDataListener);
        if (profilerListenerAdapter != null) {
            try {
                this.profilerJmeService.removeProfilerObserver((ProfilerObserver)profilerListenerAdapter);
            }
            catch (CommException commException) {
                LOGGER.error((Object)("Could not unregister profiler observer: " + (Object)((Object)commException)));
            }
        }
        this.listenerAdapters.remove(profileDataListener);
    }

    public ProfileDataRecord getNextRecord(int n) {
        ProfilerStreamAdapter profilerStreamAdapter = this.streamAdapters.get(n);
        if (profilerStreamAdapter == null) {
            LOGGER.warn((Object)"Profiler data listener asked for record from not existing stream.");
            return null;
        }
        return profilerStreamAdapter.getNextRecord();
    }

    public ProfileDataRecord[] getNextRecords(int n) {
        ProfilerStreamAdapter profilerStreamAdapter = this.streamAdapters.get(n);
        if (profilerStreamAdapter == null) {
            LOGGER.warn((Object)"Profiler data listener asked for records from not existing stream.");
            return null;
        }
        return profilerStreamAdapter.getNextRecords();
    }

    public void closeStream(int n) {
        ProfilerStreamAdapter profilerStreamAdapter = this.streamAdapters.get(n);
        if (profilerStreamAdapter == null) {
            LOGGER.warn((Object)"Profiler data listener asked to close not existing stream.");
            return;
        }
        profilerStreamAdapter.close();
        this.streamAdapters.remove(n);
    }

    public void stop() {
        Integer[] integerArray;
        Integer[] integerArray2 = integerArray = this.streamAdapters.keySet().toArray(new Integer[0]);
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            this.closeStream(n2);
        }
        for (Integer n3 : integerArray2 = this.listenerAdapters.keySet().toArray(new ProfileDataListener[0])) {
            this.removeProfileDataListener((ProfileDataListener)n3);
        }
    }

    public class ProfilerStreamAdapter {
        private ProfilerRecordStream stream;
        private ProfilerRecordBuffer buffer;
        private boolean endOfStream;

        public ProfilerStreamAdapter(ProfilerRecordStream profilerRecordStream) {
            this.stream = profilerRecordStream;
            this.endOfStream = false;
        }

        public ProfileDataRecord getNextRecord() {
            if (this.endOfStream) {
                return null;
            }
            try {
                ProfilerRecord profilerRecord = this.stream.getNextRecord();
                return this.translate(profilerRecord);
            }
            catch (CommException commException) {
                LOGGER.error((Object)("Cannot retrieve profiler record: " + (Object)((Object)commException)));
                this.endOfStream = true;
                return null;
            }
        }

        public ProfileDataRecord[] getNextRecords() {
            if (this.endOfStream) {
                return null;
            }
            if (this.buffer == null) {
                this.buffer = new ProfilerRecordBuffer(ProfilerAdapter.this.bufferSize);
            } else {
                this.buffer.clear();
            }
            try {
                this.stream.getNextRecords(this.buffer);
            }
            catch (CommException commException) {
                LOGGER.error((Object)("Cannot retrieve profiler records: " + (Object)((Object)commException)));
                this.endOfStream = true;
                return null;
            }
            int n = this.buffer.getRecordCount();
            if (n < ProfilerAdapter.this.bufferSize) {
                this.endOfStream = true;
            }
            ProfileDataRecord[] profileDataRecordArray = new ProfileDataRecord[n];
            for (int i = 0; i < n; ++i) {
                profileDataRecordArray[i] = this.translate(this.buffer.getRecord(i));
            }
            return profileDataRecordArray;
        }

        public void close() {
            try {
                this.stream.close();
            }
            catch (CommException commException) {
                LOGGER.error((Object)("Could not close profiler stream: " + (Object)((Object)commException)));
            }
        }

        private ProfileDataRecord translate(ProfilerRecord profilerRecord) {
            ProfileDataRecord profileDataRecord = new ProfileDataRecord();
            profileDataRecord.setBegin(profilerRecord.getBegin());
            profileDataRecord.setCount(profilerRecord.getCount());
            profileDataRecord.setCycles(profilerRecord.getCycles());
            profileDataRecord.setCyclesIncludingKids(profilerRecord.getCyclesIncludingKids());
            profileDataRecord.setDepth(profilerRecord.getDepth());
            profileDataRecord.setEnd(profilerRecord.getEnd());
            profileDataRecord.setId(profilerRecord.getId());
            profileDataRecord.setInterruptCount(profilerRecord.getInterruptCount());
            profileDataRecord.setInterruptTime(profilerRecord.getInterruptTime());
            profileDataRecord.setMethod(profilerRecord.getMethod());
            profileDataRecord.setParentId(profilerRecord.getParentId());
            profileDataRecord.setPercent(profilerRecord.getPercent());
            profileDataRecord.setPercentIncludingKids(profilerRecord.getPercentIncludingKids());
            profileDataRecord.setTime(profilerRecord.getTime());
            profileDataRecord.setTimeIncludingKids(profilerRecord.getTimeIncludingKids());
            return profileDataRecord;
        }
    }

    public class ProfilerListenerAdapter
    implements ProfilerObserver {
        private ProfileDataListener listener;

        public ProfilerListenerAdapter(ProfileDataListener profileDataListener) {
            this.listener = profileDataListener;
        }

        public void processProfileData(int n, ProfilerRecordStream profilerRecordStream) throws CommException {
            int n2 = ++ProfilerAdapter.this.idCounter;
            ProfilerStreamAdapter profilerStreamAdapter = new ProfilerStreamAdapter(profilerRecordStream);
            ProfilerAdapter.this.streamAdapters.put(n2, profilerStreamAdapter);
            this.listener.processProfileData(n, n2);
        }
    }
}

