/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.flashmanagement;

import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import com.sun.spot.flashmanagement.INorFlashSectorFactory;
import com.sun.spot.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

abstract class FATRecord {
    static final int NOT_WRITTEN_YET_OFFSET = -1;
    static final byte FILE_FAT_RECORD_TYPE = 0;
    static final short UNUSED_FAT_RECORD_STATUS = -1;
    static final short DELETED_FAT_RECORD_STATUS = 0;
    static final short FAT_RECORD_HEADER_SIZE = 4;
    static final short CURRENT_FAT_RECORD_STATUS = 255;
    static final byte[] DELETED_FAT_RECORD_STATUS_AS_BYTE_ARRAY = new byte[]{0, 0};
    private int offsetInFAT;
    protected boolean needsWriting;

    public FATRecord(int offsetInFAT) {
        this.offsetInFAT = offsetInFAT;
        this.needsWriting = offsetInFAT == -1;
    }

    public int getOffsetInFAT() {
        return this.offsetInFAT;
    }

    public void setOffsetInFAT(int offsetInFAT) {
        this.offsetInFAT = offsetInFAT;
    }

    public byte[] asFATRecord() throws IOException {
        boolean recordHasOddLength;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(255);
        dos.writeShort(0);
        dos.write(this.getRecordType());
        this.writeRecord(dos);
        boolean bl = recordHasOddLength = baos.size() % 2 != 0;
        if (recordHasOddLength) {
            dos.write(255);
        }
        byte[] result = baos.toByteArray();
        Utils.writeBigEndShort(result, 2, recordHasOddLength ? result.length - 1 : result.length);
        return result;
    }

    public boolean needsWriting() {
        return this.needsWriting;
    }

    public boolean needsDeleting() {
        return this.needsWriting && this.offsetInFAT != -1;
    }

    public void setClean() {
        this.needsWriting = false;
    }

    abstract void writeRecord(DataOutputStream var1) throws IOException;

    abstract byte getRecordType();

    Vector readSectorList(INorFlashSectorFactory factory, DataInputStream dis) throws IOException {
        Vector<IAddressableNorFlashSector> sectors = new Vector<IAddressableNorFlashSector>();
        int freeSectorCount = dis.readShort();
        for (int i = 0; i < freeSectorCount; ++i) {
            sectors.addElement(factory.create(dis.readShort(), 2));
        }
        return sectors;
    }
}

