/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.flashmanagement;

import com.sun.spot.flashmanagement.FlashFileDescriptor;
import com.sun.spot.flashmanagement.FlashFileNotFoundException;
import com.sun.spot.flashmanagement.FlashManager;
import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import com.sun.spot.flashmanagement.IFAT;
import com.sun.spot.flashmanagement.IFlashManager;
import com.sun.spot.flashmanagement.INorFlashSectorFactory;
import com.sun.spot.flashmanagement.NorFlashSectorFactory;
import com.sun.spot.globals.SpotGlobals;
import com.sun.spot.peripheral.ConfigPage;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.squawk.peripheral.InsufficientFlashMemoryException;
import java.io.IOException;

public class FlashFile {
    public static final int SPOT_GLOBAL_FLASH_MANAGER = 1;
    public static final int SPOT_GLOBAL_NOR_FLASH_SECTOR_FACTORY = 2;
    public static final int VIRTUAL_ADDRESS_FILE_SPACING = 0x100000;
    public static final long FIRST_FILE_VIRTUAL_ADDRESS = 0x10800000L;
    static final int VIRTUAL_ADDRESS_FILE_COUNT = 8;
    public static final long LAST_FILE_VIRTUAL_ADDRESS = 0x10F00000L;
    private String name;
    public static final int FAT_IDENTIFIER_V1 = 305419896;
    public static final int FAT_IDENTIFIER_V2 = 305419897;
    public static final int FAT_IDENTIFIER_V3 = 305419898;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNorFlashSectorFactory(INorFlashSectorFactory norFlashSectorFactory) throws IOException {
        Object object = SpotGlobals.getMutex();
        synchronized (object) {
            SpotGlobals.setGlobal((int)2, (Object)norFlashSectorFactory);
            SpotGlobals.setGlobal((int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetFAT() throws IOException {
        Object object = SpotGlobals.getMutex();
        synchronized (object) {
            int highestSectorNumberKnownOnDevice = ConfigPage.LAST_COMMON_FILE_SYSTEM_SECTOR;
            FlashManager theFlashManager = new FlashManager(20, highestSectorNumberKnownOnDevice);
            theFlashManager.initFilingSystem(FlashFile.getNorFlashSectorFactory());
            SpotGlobals.setGlobal((int)1, (Object)theFlashManager);
        }
    }

    public static IFAT getFAT() {
        return FlashFile.getFlashManager();
    }

    public static int getUnusedVirtualAddress() throws IOException {
        return FlashFile.getFlashManager().allocateVirtualAddress();
    }

    public FlashFile(String name) {
        this.name = name;
    }

    public boolean createNewFile(int size) throws InsufficientFlashMemoryException {
        if (this.exists()) {
            return false;
        }
        FlashFile.getFlashManager().createFile(this.name, size);
        return true;
    }

    public boolean exists() {
        return FlashFile.getFlashManager().exists(this.name);
    }

    public void delete() throws IOException {
        FlashFile.getFlashManager().deleteFile(this.name);
        FlashFile.getFlashManager().writeFAT();
    }

    public int length() throws IOException {
        if (!this.exists()) {
            return 0;
        }
        return this.getFileDescriptor().length();
    }

    public void commit() throws IOException {
        this.getFileDescriptor().setLastModifiedMillis(System.currentTimeMillis());
        FlashFile.getFlashManager().writeFAT();
    }

    public void setVirtualAddress(int virtualAddress) throws IOException {
        if (this.getFileDescriptor().getVirtualAddress() != 0) {
            throw new IllegalStateException("File already has a virtual address");
        }
        if (virtualAddress == this.getFileDescriptor().getVirtualAddress()) {
            return;
        }
        FlashFile.getFlashManager().validateVirtualAddress(virtualAddress);
        this.getFileDescriptor().setVirtualAddress(virtualAddress);
        this.getFileDescriptor().setLastModifiedMillis(System.currentTimeMillis());
    }

    public void setComment(String comment) throws IOException {
        this.getFileDescriptor().setLastModifiedMillis(System.currentTimeMillis());
        this.getFileDescriptor().setComment(comment);
    }

    public int getVirtualAddress() throws IOException {
        return this.getFileDescriptor().getVirtualAddress();
    }

    public String getComment() throws IOException {
        return this.getFileDescriptor().getComment();
    }

    public long lastModified() throws IOException {
        return this.getFileDescriptor().lastModified();
    }

    public void setObsolete(boolean b) throws IOException {
        this.getFileDescriptor().setLastModifiedMillis(System.currentTimeMillis());
        this.getFileDescriptor().setObsolete(b);
    }

    public boolean isObsolete() throws IOException {
        return this.getFileDescriptor().isObsolete();
    }

    public void map() throws IOException {
        if (this.getFileDescriptor().isMapped()) {
            throw new IllegalStateException("Cannot map a file that is already mapped");
        }
        FlashFile.getFlashManager().remap(this.name);
    }

    public boolean isMapped() throws IOException {
        return this.getFileDescriptor().isMapped();
    }

    public boolean isAddressed() throws IOException {
        return this.getFileDescriptor().isAddressed();
    }

    public int getAllocatedSpace() throws IOException {
        return this.getFileDescriptor().getAllocatedSpace();
    }

    public String getName() {
        return this.name;
    }

    public boolean renameTo(FlashFile dest) throws IOException {
        boolean result = FlashFile.getFlashManager().rename(this.getFileDescriptor(), dest.getName());
        if (result) {
            FlashFile.getFlashManager().writeFAT();
        }
        return result;
    }

    public int getFirstSectorBaseAddress() throws IOException {
        return this.getFileDescriptor().getSectors()[0].getStartAddressAsInt();
    }

    IAddressableNorFlashSector getExtraSector() throws IOException {
        IAddressableNorFlashSector extraSector = FlashFile.getFlashManager().getExtraSector(this.getFileDescriptor());
        FlashFile.getFlashManager().writeFAT();
        return extraSector;
    }

    void releaseSector(IAddressableNorFlashSector sector) throws IOException {
        FlashFile.getFlashManager().releaseSector(this.getFileDescriptor(), sector);
        FlashFile.getFlashManager().writeFAT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IFlashManager getFlashManager() {
        IFlashManager theFlashManager;
        Object object = SpotGlobals.getMutex();
        synchronized (object) {
            theFlashManager = (IFlashManager)SpotGlobals.getGlobal((int)1);
            if (theFlashManager == null) {
                try {
                    int highestSectorNumberKnownOnDevice = RadioFactory.isRunningOnHost() ? ConfigPage.LAST_COMMON_FILE_SYSTEM_SECTOR : Spot.getInstance().getFlashMemoryDevice().getLastSectorAvailableToJava();
                    theFlashManager = new FlashManager(20, highestSectorNumberKnownOnDevice);
                    ((FlashManager)theFlashManager).initFromStoredFAT(FlashFile.getNorFlashSectorFactory());
                    SpotGlobals.setGlobal((int)1, (Object)theFlashManager);
                }
                catch (IOException e) {
                    throw new SpotFatalException("Unexpected IOException while creating FlashManager");
                }
            }
        }
        return theFlashManager;
    }

    FlashFileDescriptor getFileDescriptor() throws FlashFileNotFoundException {
        return FlashFile.getFlashManager().getFileDescriptorFor(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INorFlashSectorFactory getNorFlashSectorFactory() {
        INorFlashSectorFactory norFlashSectorFactory;
        Object object = SpotGlobals.getMutex();
        synchronized (object) {
            norFlashSectorFactory = (INorFlashSectorFactory)SpotGlobals.getGlobal((int)2);
            if (norFlashSectorFactory == null) {
                norFlashSectorFactory = new NorFlashSectorFactory(Spot.getInstance().getFlashMemoryDevice());
                SpotGlobals.setGlobal((int)2, (Object)norFlashSectorFactory);
            }
        }
        return norFlashSectorFactory;
    }
}

