/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.flashmanagement;

import com.sun.spot.flashmanagement.FATRecord;
import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import com.sun.spot.flashmanagement.IExtendedFlashFileInfo;
import com.sun.spot.flashmanagement.INorFlashSectorFactory;
import com.sun.spot.peripheral.SpotFatalException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

class FlashFileDescriptor
extends FATRecord
implements IExtendedFlashFileInfo {
    private static final short OBSOLETE_FLAG_MASK = 1;
    private int fileSize;
    private Vector sectors;
    private String name;
    private int virtualAddress;
    private long lastModifiedMillis;
    private String comment;
    private short flags;
    private int allocatedSpace;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.needsWriting = true;
    }

    public long lastModified() {
        return this.lastModifiedMillis;
    }

    public void setLastModifiedMillis(long lastModifiedMillis) {
        this.lastModifiedMillis = lastModifiedMillis;
        this.needsWriting = true;
    }

    public int getVirtualAddress() {
        return this.virtualAddress;
    }

    public void setVirtualAddress(int virtualAddress) {
        this.virtualAddress = virtualAddress;
        this.needsWriting = true;
    }

    public FlashFileDescriptor(String name, int fileSize, Vector sectorsForFile, int virtualAddress, long lastModifiedMillis, String comment, short flags) {
        super(-1);
        this.flags = flags;
        this.virtualAddress = virtualAddress;
        this.sectors = sectorsForFile;
        this.name = name;
        this.fileSize = fileSize;
        this.lastModifiedMillis = lastModifiedMillis;
        this.comment = comment;
        this.calculateAllocatedSpace();
    }

    public FlashFileDescriptor(INorFlashSectorFactory factory, DataInputStream dis, int fatOffset) throws IOException {
        super(fatOffset);
        this.flags = dis.readShort();
        this.virtualAddress = dis.readInt();
        this.sectors = this.readSectorList(factory, dis);
        this.name = dis.readUTF();
        this.fileSize = dis.readInt();
        this.lastModifiedMillis = dis.readLong();
        this.comment = dis.readUTF();
        this.calculateAllocatedSpace();
    }

    public IAddressableNorFlashSector getNextSector(IAddressableNorFlashSector sector) {
        for (int i = 0; i < this.sectors.size(); ++i) {
            IAddressableNorFlashSector s = (IAddressableNorFlashSector)this.sectors.elementAt(i);
            if (s != sector) continue;
            if (i == this.sectors.size() - 1) {
                throw new SpotFatalException("FlashFileDescriptor has been asked for a sector beyond the allocated space");
            }
            return (IAddressableNorFlashSector)this.sectors.elementAt(i + 1);
        }
        throw new SpotFatalException("FlashFileDescriptor: sector not found in getNextSector");
    }

    public int length() {
        return this.fileSize;
    }

    public int getAllocatedSpace() {
        return this.allocatedSpace;
    }

    private void calculateAllocatedSpace() {
        this.allocatedSpace = 0;
        for (int i = 0; i < this.sectors.size(); ++i) {
            this.allocatedSpace += ((IAddressableNorFlashSector)this.sectors.elementAt(i)).getSize();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.needsWriting = true;
    }

    public IAddressableNorFlashSector getFirstSector() {
        return (IAddressableNorFlashSector)this.sectors.firstElement();
    }

    public void setFileSize(int numOfBytesInFile) {
        this.fileSize = numOfBytesInFile;
    }

    public IAddressableNorFlashSector[] getSectors() {
        Object[] addressableNorFlashSectors = new IAddressableNorFlashSector[this.sectors.size()];
        this.sectors.copyInto(addressableNorFlashSectors);
        return addressableNorFlashSectors;
    }

    public boolean isMapped() {
        if (!this.isAddressed()) {
            return false;
        }
        int offset = 0;
        for (int i = 0; i < this.sectors.size(); ++i) {
            IAddressableNorFlashSector addressableNorFlashSector = (IAddressableNorFlashSector)this.sectors.elementAt(i);
            if (this.virtualAddress + offset != addressableNorFlashSector.getVirtualStartAddressAsInt()) {
                return false;
            }
            offset += addressableNorFlashSector.getSize();
        }
        return true;
    }

    public void setObsolete(boolean b) {
        this.flags = b ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    public boolean isObsolete() {
        return (this.flags & 1) != 0;
    }

    short getFlags() {
        return this.flags;
    }

    public boolean isAddressed() {
        return this.virtualAddress != 0;
    }

    public void addSector(IAddressableNorFlashSector sector) {
        this.sectors.addElement(sector);
        this.calculateAllocatedSpace();
        this.needsWriting = true;
    }

    public void removeSector(IAddressableNorFlashSector sector) {
        if (!this.sectors.removeElement(sector)) {
            throw new SpotFatalException("Sector " + sector.getSectorNumber() + " is not part of " + this.name);
        }
        this.calculateAllocatedSpace();
        this.needsWriting = true;
    }

    public boolean exists() {
        return true;
    }

    public int[] getSectorNumbers() {
        int[] result = new int[this.sectors.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((IAddressableNorFlashSector)this.sectors.elementAt(i)).getSectorNumber();
        }
        return result;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.isObsolete()) {
            sb.append(" [obsolete]");
        }
        sb.append(this.getVirtualAddress() == 0 ? " [unmapped]" : " [mapped at 0x" + Integer.toHexString(this.getVirtualAddress()) + "]");
        sb.append(lineSeparator);
        String string = "    sectors:";
        int[] sectors = this.getSectorNumbers();
        for (int j = 0; j < sectors.length; ++j) {
            string = string + " 0x" + Integer.toHexString(sectors[j]);
        }
        sb.append(string);
        sb.append(lineSeparator);
        sb.append("    comment: " + this.getComment());
        sb.append(lineSeparator);
        sb.append("    last modified: " + new Date(this.lastModified()));
        sb.append(lineSeparator);
        sb.append("    size: " + this.length());
        sb.append(lineSeparator);
        return sb.toString();
    }

    public byte getRecordType() {
        return 0;
    }

    public void writeRecord(DataOutputStream dos) throws IOException {
        dos.writeShort(this.getFlags());
        dos.writeInt(this.getVirtualAddress());
        IAddressableNorFlashSector[] sectors = this.getSectors();
        dos.writeShort(sectors.length);
        for (int i = 0; i < sectors.length; ++i) {
            dos.writeShort(sectors[i].getSectorNumber());
        }
        dos.writeUTF(this.getName());
        dos.writeInt(this.length());
        dos.writeLong(this.lastModified());
        dos.writeUTF(this.getComment());
    }
}

