/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.flashmanagement;

import com.sun.spot.flashmanagement.FlashFile;
import com.sun.spot.flashmanagement.FlashFileDescriptor;
import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class FlashFileInputStream
extends InputStream {
    private byte[] singleByteBuffer = new byte[1];
    private int offsetInSector;
    private IAddressableNorFlashSector currentSector;
    private FlashFileDescriptor fileDescriptor;
    private int offsetInFile;

    public FlashFileInputStream(FlashFile file) throws IOException {
        this(file.getFileDescriptor());
    }

    public FlashFileInputStream(final IAddressableNorFlashSector sector) {
        this(new FlashFileDescriptor("temp", sector.getSize(), new Vector(1){
            {
                this.addElement(sector);
            }
        }, 0, 0L, "", 0));
    }

    FlashFileInputStream(FlashFileDescriptor flashFileDescriptor) {
        this.fileDescriptor = flashFileDescriptor;
        this.offsetInSector = 0;
        this.offsetInFile = 0;
        this.currentSector = this.fileDescriptor.getFirstSector();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numberOfBytesToReturn = Math.min(len, this.fileDescriptor.length() - this.offsetInFile);
        if (numberOfBytesToReturn == 0) {
            return -1;
        }
        int numberOfBytesToRead = numberOfBytesToReturn;
        while (numberOfBytesToRead > 0) {
            if (this.offsetInSector == this.currentSector.getSize()) {
                this.currentSector = this.fileDescriptor.getNextSector(this.currentSector);
                this.offsetInSector = 0;
            }
            int lenToReadFromThisSector = Math.min(numberOfBytesToRead, this.currentSector.getSize() - this.offsetInSector);
            this.currentSector.getBytes(this.offsetInSector, b, off, lenToReadFromThisSector);
            off += lenToReadFromThisSector;
            numberOfBytesToRead -= lenToReadFromThisSector;
            this.offsetInSector += lenToReadFromThisSector;
            this.offsetInFile += lenToReadFromThisSector;
        }
        return numberOfBytesToReturn;
    }

    public int read() throws IOException {
        if (this.offsetInFile == this.fileDescriptor.length()) {
            return -1;
        }
        if (this.offsetInSector == this.currentSector.getSize()) {
            this.currentSector = this.fileDescriptor.getNextSector(this.currentSector);
            this.offsetInSector = 0;
        }
        this.currentSector.getBytes(this.offsetInSector++, this.singleByteBuffer, 0, 1);
        ++this.offsetInFile;
        return this.singleByteBuffer[0] & 0xFF;
    }
}

