/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.flashmanagement;

import com.sun.spot.flashmanagement.FlashFile;
import com.sun.spot.flashmanagement.FlashFileDescriptor;
import com.sun.spot.flashmanagement.FlashFileNotFoundException;
import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class FlashFileOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    private byte[] buffer;
    private int numOfBytesWrittenInSector;
    private IAddressableNorFlashSector currentSector;
    private FlashFileDescriptor fileDescriptor;
    private int numOfBytesInFile;
    private int numOfBytesInBuffer;
    private FlashFile file = null;

    public FlashFileOutputStream(FlashFile file) throws FlashFileNotFoundException {
        this(file, 512);
    }

    public FlashFileOutputStream(FlashFile file, int bufferSize) throws FlashFileNotFoundException {
        this(file.getFileDescriptor(), bufferSize);
        this.file = file;
    }

    public FlashFileOutputStream(final IAddressableNorFlashSector sector) throws FlashFileNotFoundException {
        this(new FlashFileDescriptor("temp", 0, new Vector(1){
            {
                this.addElement(sector);
            }
        }, 0, 0L, "", 0), 512);
    }

    private FlashFileOutputStream(FlashFileDescriptor fileDescriptor, int bufferSize) throws FlashFileNotFoundException {
        this.buffer = new byte[bufferSize];
        this.fileDescriptor = fileDescriptor;
        this.numOfBytesInBuffer = 0;
        this.numOfBytesWrittenInSector = 0;
        this.numOfBytesInFile = 0;
        this.currentSector = fileDescriptor.getFirstSector();
        fileDescriptor.setFileSize(0);
        IAddressableNorFlashSector[] sectors = fileDescriptor.getSectors();
        for (int i = 0; i < sectors.length; ++i) {
            sectors[i].erase();
        }
    }

    public void write(int b) throws IOException {
        if (this.numOfBytesInFile == this.fileDescriptor.getAllocatedSpace()) {
            throw new IOException("File " + this.fileDescriptor.getName() + " is full");
        }
        this.buffer[this.numOfBytesInBuffer++] = (byte)b;
        if (this.numOfBytesInBuffer == this.buffer.length) {
            this.writeOutBuffer();
        }
        ++this.numOfBytesInFile;
    }

    public void flush() throws IOException {
        int numOfBytesInBufferOnEntry = this.numOfBytesInBuffer;
        this.writeOutBuffer();
        if (numOfBytesInBufferOnEntry % 2 != 0) {
            this.buffer[this.numOfBytesInBuffer++] = this.buffer[numOfBytesInBufferOnEntry - 1];
            this.numOfBytesInBuffer = 1;
            --this.numOfBytesWrittenInSector;
        }
        this.fileDescriptor.setFileSize(this.numOfBytesInFile);
        if (this.file != null) {
            this.file.commit();
        }
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    private void writeOutBuffer() {
        int unusedBytesInSector = this.currentSector.getSize() - this.numOfBytesWrittenInSector;
        if (this.numOfBytesInBuffer > unusedBytesInSector) {
            this.currentSector.setBytes(this.numOfBytesWrittenInSector, this.buffer, 0, unusedBytesInSector);
            this.currentSector = this.fileDescriptor.getNextSector(this.currentSector);
            this.currentSector.setBytes(0, this.buffer, unusedBytesInSector, this.numOfBytesInBuffer - unusedBytesInSector);
            this.numOfBytesWrittenInSector = this.numOfBytesInBuffer - unusedBytesInSector;
        } else {
            this.currentSector.setBytes(this.numOfBytesWrittenInSector, this.buffer, 0, this.numOfBytesInBuffer);
            this.numOfBytesWrittenInSector += this.numOfBytesInBuffer;
        }
        this.numOfBytesInBuffer = 0;
    }
}

