/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.flashmanagement;

import com.sun.spot.flashmanagement.FATRecord;
import com.sun.spot.flashmanagement.FlashFileDescriptor;
import com.sun.spot.flashmanagement.FlashFileInputStream;
import com.sun.spot.flashmanagement.FlashFileNotFoundException;
import com.sun.spot.flashmanagement.FreeSectorsList;
import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import com.sun.spot.flashmanagement.IFlashFileInfo;
import com.sun.spot.flashmanagement.IFlashManager;
import com.sun.spot.flashmanagement.INorFlashSectorFactory;
import com.sun.spot.peripheral.SpotFatalException;
import com.sun.spot.util.Utils;
import com.sun.squawk.VM;
import com.sun.squawk.peripheral.InsufficientFlashMemoryException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FlashManager
implements IFlashManager {
    Hashtable fileDescriptors;
    FreeSectorsList freeSectorsRecord;
    Vector needsDeleting = new Vector();
    private IAddressableNorFlashSector fatSector;
    private INorFlashSectorFactory flashSectorFactory;
    private int fatWriteOffset;
    private int lowestSectorInFilingSystem;
    private int highestSectorInFilingSystem;

    FlashManager(int lowestSectorInFilingSystem, int highestSectorInFilingSystem) {
        this.lowestSectorInFilingSystem = lowestSectorInFilingSystem;
        this.highestSectorInFilingSystem = highestSectorInFilingSystem;
    }

    public void initFilingSystem(INorFlashSectorFactory factory) {
        this.flashSectorFactory = factory;
        this.resetFAT();
        this.fileDescriptors = new Hashtable();
        this.freeSectorsRecord = new FreeSectorsList(this.lowestSectorInFilingSystem, this.highestSectorInFilingSystem, factory);
    }

    private void resetFAT() {
        this.getFatSector().erase();
        byte[] buffer = new byte[4];
        Utils.writeBigEndInt(buffer, 0, 305419898);
        this.getFatSector().setBytes(0, buffer, 0, buffer.length);
        this.fatWriteOffset = buffer.length;
    }

    public void initFromStoredFAT(INorFlashSectorFactory factory) throws IOException {
        this.flashSectorFactory = factory;
        this.initFrom(new FlashFileInputStream(this.getFatSector()), factory);
    }

    void initFrom(InputStream is, INorFlashSectorFactory factory) throws IOException {
        this.flashSectorFactory = factory;
        this.fileDescriptors = new Hashtable();
        DataInputStream dis = new DataInputStream(is);
        int identifierInt = dis.readInt();
        if (identifierInt != 305419898) {
            throw new SpotFatalException("This is not a FAT 0x" + Integer.toHexString(identifierInt));
        }
        this.freeSectorsRecord = new FreeSectorsList();
        int fatOffset = 4;
        short recordStatus = dis.readShort();
        while (recordStatus != -1) {
            short recordSize = dis.readShort();
            block0 : switch (recordStatus) {
                case 0: {
                    dis.skip(recordSize - 4);
                    break;
                }
                case 255: {
                    byte recordType = dis.readByte();
                    switch (recordType) {
                        case 0: {
                            this.readFATFileRecord(factory, dis, fatOffset);
                            break block0;
                        }
                    }
                    throw new IOException("[FlashManager] FAT contains bad record type " + recordType);
                }
                default: {
                    throw new IOException("[FlashManager] FAT contains bad record status " + recordStatus);
                }
            }
            fatOffset += recordSize;
            if (recordSize % 2 != 0) {
                dis.skip(1L);
                ++fatOffset;
            }
            recordStatus = dis.readShort();
        }
        this.fatWriteOffset = fatOffset;
        Enumeration e = this.fileDescriptors.elements();
        while (e.hasMoreElements()) {
            FlashFileDescriptor descriptor = (FlashFileDescriptor)e.nextElement();
            IAddressableNorFlashSector[] sectors = descriptor.getSectors();
            for (int i = 0; i < sectors.length; ++i) {
                this.highestSectorInFilingSystem = Math.max(this.highestSectorInFilingSystem, sectors[i].getSectorNumber());
            }
        }
        boolean[] sectorsInUse = new boolean[this.highestSectorInFilingSystem + 1];
        e = this.fileDescriptors.elements();
        while (e.hasMoreElements()) {
            FlashFileDescriptor descriptor = (FlashFileDescriptor)e.nextElement();
            IAddressableNorFlashSector[] sectors = descriptor.getSectors();
            for (int i = 0; i < sectors.length; ++i) {
                sectorsInUse[sectors[i].getSectorNumber()] = true;
            }
        }
        for (int i = this.lowestSectorInFilingSystem; i < sectorsInUse.length; ++i) {
            if (sectorsInUse[i]) continue;
            this.freeSectorsRecord.addSectorNumber(this.flashSectorFactory.create(i, 2));
        }
    }

    private void readFATFileRecord(INorFlashSectorFactory factory, DataInputStream dis, int offsetInFAT) throws IOException {
        FlashFileDescriptor flashFileDescriptor = new FlashFileDescriptor(factory, dis, offsetInFAT);
        if (!flashFileDescriptor.isObsolete()) {
            if (flashFileDescriptor.getVirtualAddress() != 0) {
                this.mapSectors(flashFileDescriptor);
            }
            this.fileDescriptors.put(flashFileDescriptor.getName(), flashFileDescriptor);
        } else {
            this.addToNeedsDeleting(flashFileDescriptor);
        }
    }

    public synchronized FlashFileDescriptor createFile(String name, int size) throws InsufficientFlashMemoryException {
        if (this.exists(name)) {
            throw new SpotFatalException("Cannot create file " + name + " - already exists");
        }
        Vector sectors = this.freeSectorsRecord.allocateSectors(name, size);
        FlashFileDescriptor flashFileDescriptor = new FlashFileDescriptor(name, 0, sectors, 0, System.currentTimeMillis(), "", 0);
        this.fileDescriptors.put(name, flashFileDescriptor);
        return flashFileDescriptor;
    }

    public synchronized int allocateVirtualAddress() {
        for (long guessedAddress = 0x10800000L; guessedAddress <= 0x10F00000L; guessedAddress += 0x100000L) {
            if (this.isVirtualAddressInUse((int)guessedAddress)) continue;
            return (int)guessedAddress;
        }
        throw new SpotFatalException("Virtual address space exhausted");
    }

    private boolean isVirtualAddressInUse(int virtualAddress) {
        Enumeration e = this.fileDescriptors.elements();
        while (e.hasMoreElements()) {
            FlashFileDescriptor descriptor = (FlashFileDescriptor)e.nextElement();
            if (descriptor.getVirtualAddress() != virtualAddress || descriptor.isObsolete()) continue;
            return true;
        }
        return false;
    }

    public boolean exists(String name) {
        return this.fileDescriptors.containsKey(name);
    }

    public FlashFileDescriptor getFileDescriptorFor(String name) throws FlashFileNotFoundException {
        if (this.exists(name)) {
            return (FlashFileDescriptor)this.fileDescriptors.get(name);
        }
        throw new FlashFileNotFoundException("File not found " + name);
    }

    public synchronized void deleteFile(String name) {
        if (this.exists(name)) {
            FlashFileDescriptor descriptor = (FlashFileDescriptor)this.fileDescriptors.remove(name);
            this.addToNeedsDeleting(descriptor);
            this.freeSectorsRecord.addSectors(descriptor.getSectors());
        }
    }

    public synchronized void writeFAT() throws IOException {
        byte[] recordAsByteArray;
        FATRecord record;
        Hashtable<FATRecord, byte[]> recordsToWrite = new Hashtable<FATRecord, byte[]>();
        Enumeration<Object> e = this.fileDescriptors.elements();
        int totalSize = 0;
        while (e.hasMoreElements()) {
            record = (FATRecord)e.nextElement();
            if (!record.needsWriting()) continue;
            byte[] fatRecord = record.asFATRecord();
            recordsToWrite.put(record, fatRecord);
            totalSize += fatRecord.length;
        }
        if (this.getFatSector().getSize() - this.fatWriteOffset - 2 >= totalSize) {
            e = this.needsDeleting.elements();
            while (e.hasMoreElements()) {
                record = (FATRecord)e.nextElement();
                this.getFatSector().setBytes(record.getOffsetInFAT(), FATRecord.DELETED_FAT_RECORD_STATUS_AS_BYTE_ARRAY, 0, FATRecord.DELETED_FAT_RECORD_STATUS_AS_BYTE_ARRAY.length);
            }
            e = this.fileDescriptors.elements();
            while (e.hasMoreElements()) {
                record = (FATRecord)e.nextElement();
                if (record.needsDeleting()) {
                    this.getFatSector().setBytes(record.getOffsetInFAT(), FATRecord.DELETED_FAT_RECORD_STATUS_AS_BYTE_ARRAY, 0, FATRecord.DELETED_FAT_RECORD_STATUS_AS_BYTE_ARRAY.length);
                }
                record.setClean();
            }
            e = recordsToWrite.keys();
            while (e.hasMoreElements()) {
                record = (FATRecord)e.nextElement();
                recordAsByteArray = (byte[])recordsToWrite.get(record);
                this.getFatSector().setBytes(this.fatWriteOffset, recordAsByteArray, 0, recordAsByteArray.length);
                record.setOffsetInFAT(this.fatWriteOffset);
                this.fatWriteOffset += recordAsByteArray.length;
            }
        } else {
            this.resetFAT();
            e = this.fileDescriptors.elements();
            while (e.hasMoreElements()) {
                record = (FATRecord)e.nextElement();
                recordAsByteArray = record.asFATRecord();
                if (this.getFatSector().getSize() - this.fatWriteOffset - 2 < recordAsByteArray.length) {
                    throw new SpotFatalException("FAT is full");
                }
                this.getFatSector().setBytes(this.fatWriteOffset, recordAsByteArray, 0, recordAsByteArray.length);
                record.setOffsetInFAT(this.fatWriteOffset);
                this.fatWriteOffset += recordAsByteArray.length;
                record.setClean();
            }
        }
        this.needsDeleting = new Vector();
    }

    FlashFileDescriptor[] getFileDescriptors() {
        FlashFileDescriptor[] result = new FlashFileDescriptor[this.fileDescriptors.size()];
        Enumeration e = this.fileDescriptors.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            result[index++] = (FlashFileDescriptor)e.nextElement();
        }
        return result;
    }

    Vector getFreeSectors() {
        return this.freeSectorsRecord.getFreeSectors();
    }

    public synchronized void remap(String filename) {
        this.remap((FlashFileDescriptor)this.fileDescriptors.get(filename));
    }

    private void remap(FlashFileDescriptor flashFileDescriptor) {
        if (!flashFileDescriptor.isAddressed()) {
            flashFileDescriptor.setVirtualAddress(this.allocateVirtualAddress());
        }
        this.mapSectors(flashFileDescriptor);
        this.reprogramMMU();
    }

    private void mapSectors(FlashFileDescriptor descriptor) {
        IAddressableNorFlashSector[] sectors = descriptor.getSectors();
        int virtualAddress = descriptor.getVirtualAddress();
        for (int i = 0; i < sectors.length; ++i) {
            sectors[i].setVirtualAddress(virtualAddress);
            virtualAddress += sectors[i].getSize();
        }
    }

    void reprogramMMU() {
        VM.execSyncIO((int)430, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, null, null);
    }

    public void validateVirtualAddress(int virtualAddress) {
        long longVirtualAddress = (long)virtualAddress & 0xFFFFFFFFL;
        if (longVirtualAddress < 0x10800000L) {
            throw new IllegalArgumentException("Virtual address 0x" + Integer.toHexString(virtualAddress) + " is too low");
        }
        if (longVirtualAddress > 0x10F00000L) {
            throw new IllegalArgumentException("Virtual address 0x" + Integer.toHexString(virtualAddress) + " is too high");
        }
        if (virtualAddress % 0x100000 != 0) {
            throw new IllegalArgumentException("Virtual address 0x" + Integer.toHexString(virtualAddress) + " is not on a valid boundary");
        }
        if (this.isVirtualAddressInUse(virtualAddress)) {
            throw new IllegalArgumentException("Virtual address 0x" + Integer.toHexString(virtualAddress) + " is already allocated");
        }
    }

    private IAddressableNorFlashSector getFatSector() {
        if (this.fatSector == null) {
            this.fatSector = this.flashSectorFactory.create(5, 2);
        }
        return this.fatSector;
    }

    public synchronized boolean rename(FlashFileDescriptor fileDescriptor, String newName) throws IOException {
        if (this.exists(newName)) {
            return false;
        }
        this.fileDescriptors.remove(fileDescriptor.getName());
        fileDescriptor.setName(newName);
        this.fileDescriptors.put(newName, fileDescriptor);
        return true;
    }

    public synchronized IAddressableNorFlashSector getExtraSector(FlashFileDescriptor fileDescriptor) throws InsufficientFlashMemoryException {
        boolean isMapped = fileDescriptor.isMapped();
        IAddressableNorFlashSector sector = this.freeSectorsRecord.allocateSector(fileDescriptor.getName());
        fileDescriptor.addSector(sector);
        if (isMapped) {
            this.remap(fileDescriptor);
        }
        return sector;
    }

    public synchronized void releaseSector(FlashFileDescriptor fileDescriptor, IAddressableNorFlashSector sector) {
        boolean mapped = fileDescriptor.isMapped();
        fileDescriptor.removeSector(sector);
        this.freeSectorsRecord.addSectors(new IAddressableNorFlashSector[]{sector});
        if (mapped) {
            this.remap(fileDescriptor);
        }
    }

    public IFlashFileInfo[] getFileInfos() {
        return this.getFileDescriptors();
    }

    public synchronized int[] getFreeSectorIndices() {
        return this.freeSectorsRecord.getFreeSectorIndices();
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        IFlashFileInfo[] fileInfos = this.getFileInfos();
        StringBuffer sb = new StringBuffer(100);
        sb.append("FAT contains " + fileInfos.length + " files.");
        sb.append(lineSeparator);
        for (int i = 0; i < fileInfos.length; ++i) {
            sb.append(" " + i + ": " + fileInfos[i].toString());
        }
        int[] freeSectorIndices = this.getFreeSectorIndices();
        String string = " Free sectors (" + freeSectorIndices.length + ") :";
        for (int i = 0; i < freeSectorIndices.length; ++i) {
            string = string + " 0x" + Integer.toHexString(freeSectorIndices[i]);
        }
        sb.append(string);
        sb.append(lineSeparator);
        return sb.toString();
    }

    private void addToNeedsDeleting(FATRecord record) {
        if (record.getOffsetInFAT() != -1) {
            this.needsDeleting.addElement(record);
        }
    }
}

