/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.flashmanagement;

import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import com.sun.spot.flashmanagement.INorFlashSectorFactory;
import com.sun.squawk.peripheral.InsufficientFlashMemoryException;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

class FreeSectorsList {
    private Vector freeSectors = new Vector();

    public FreeSectorsList(int lowestFreeSector, int highestFreeSector, INorFlashSectorFactory factory) {
        this.freeSectors = new Vector();
        for (int i = lowestFreeSector; i <= highestFreeSector; ++i) {
            this.freeSectors.addElement(factory.create(i, 2));
        }
    }

    public FreeSectorsList() throws IOException {
    }

    public void addSectors(INorFlashSectorFactory factory, DataInputStream dis) throws IOException {
        int freeSectorCount = dis.readShort();
        for (int i = 0; i < freeSectorCount; ++i) {
            this.freeSectors.addElement(factory.create(dis.readShort(), 2));
        }
    }

    public void addSectors(IAddressableNorFlashSector[] sectors) {
        for (int j = 0; j < sectors.length; ++j) {
            this.freeSectors.addElement(sectors[j]);
        }
    }

    public void addSectorNumber(IAddressableNorFlashSector sector) {
        this.freeSectors.addElement(sector);
    }

    public Vector allocateSectors(String name, int size) throws InsufficientFlashMemoryException {
        IAddressableNorFlashSector s;
        Vector<IAddressableNorFlashSector> sectors = new Vector<IAddressableNorFlashSector>();
        int freeSectorIndex = 0;
        for (int sizeSoFar = 0; sizeSoFar < size; sizeSoFar += s.getSize()) {
            if (freeSectorIndex < this.freeSectors.size()) {
                s = (IAddressableNorFlashSector)this.freeSectors.elementAt(freeSectorIndex++);
                sectors.addElement(s);
                continue;
            }
            throw new InsufficientFlashMemoryException("Not enough space to create file " + name + " (wants " + size + ", " + sizeSoFar + " available)");
        }
        Enumeration e = sectors.elements();
        while (e.hasMoreElements()) {
            this.freeSectors.removeElement(e.nextElement());
        }
        return sectors;
    }

    public Vector getFreeSectors() {
        return this.freeSectors;
    }

    public IAddressableNorFlashSector allocateSector(String name) throws InsufficientFlashMemoryException {
        if (this.freeSectors.isEmpty()) {
            throw new InsufficientFlashMemoryException("Not enough space to allocate sector for " + name);
        }
        IAddressableNorFlashSector sector = (IAddressableNorFlashSector)this.freeSectors.elementAt(0);
        this.freeSectors.removeElementAt(0);
        return sector;
    }

    public int[] getFreeSectorIndices() {
        int[] result = new int[this.freeSectors.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((IAddressableNorFlashSector)this.freeSectors.elementAt(i)).getSectorNumber();
        }
        return result;
    }
}

