/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.imp;

import com.sun.spot.flashmanagement.FlashFile;
import com.sun.spot.flashmanagement.IFAT;
import com.sun.spot.flashmanagement.IFlashFileInfo;
import com.sun.spot.imp.MIDletDescriptor;
import com.sun.spot.util.Utils;
import com.sun.squawk.VM;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MIDletSuiteDescriptor {
    private static final String MIDLET_PROP_PREFIX = "MIDlet-";
    private MIDletDescriptor[] midletDescriptors;
    private String uri;
    private String vendor;
    private String name;
    private String version;
    private long lastModified;
    private int length;
    private String sourcePath;

    public static MIDletSuiteDescriptor[] getAllInstances() {
        Vector<MIDletSuiteDescriptor> tmpResult = new Vector<MIDletSuiteDescriptor>();
        IFAT fat = FlashFile.getFAT();
        IFlashFileInfo[] fileInfos = fat.getFileInfos();
        for (int i = 0; i < fileInfos.length; ++i) {
            if (!fileInfos[i].getName().startsWith("spotsuite://") || fileInfos[i].isObsolete() || fileInfos[i].getName().equals("spotsuite://library")) continue;
            tmpResult.addElement(new MIDletSuiteDescriptor(fileInfos[i]));
        }
        Object[] result = new MIDletSuiteDescriptor[tmpResult.size()];
        tmpResult.copyInto(result);
        return result;
    }

    public MIDletSuiteDescriptor(IFlashFileInfo fileInfo) {
        this.uri = fileInfo.getName();
        this.lastModified = fileInfo.lastModified();
        this.length = fileInfo.length();
        this.sourcePath = fileInfo.getComment();
        Vector<MIDletDescriptor> tmpDescriptors = new Vector<MIDletDescriptor>();
        Hashtable properties = null;
        try {
            properties = VM.getManifestPropertiesOfSuite((String)this.uri);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (properties != null) {
            this.vendor = (String)properties.get("MIDlet-Vendor");
            this.name = (String)properties.get("MIDlet-Name");
            this.version = (String)properties.get("MIDlet-Version");
            Enumeration manifestProps = properties.keys();
            while (manifestProps.hasMoreElements()) {
                String propName = (String)manifestProps.nextElement();
                if (!propName.startsWith(MIDLET_PROP_PREFIX)) continue;
                String n = propName.substring(MIDLET_PROP_PREFIX.length());
                try {
                    int midletNum = Integer.parseInt(n);
                    String[] descriptorParts = Utils.split((String)properties.get(propName), ',');
                    MIDletDescriptor midletDescriptor = new MIDletDescriptor();
                    midletDescriptor.number = midletNum;
                    midletDescriptor.label = descriptorParts[0].trim();
                    midletDescriptor.iconName = descriptorParts[1].trim();
                    midletDescriptor.className = descriptorParts[2].trim();
                    tmpDescriptors.addElement(midletDescriptor);
                }
                catch (NumberFormatException e) {}
            }
        }
        this.midletDescriptors = new MIDletDescriptor[tmpDescriptors.size()];
        tmpDescriptors.copyInto(this.midletDescriptors);
    }

    public MIDletDescriptor[] getMIDletDescriptors() {
        return this.midletDescriptors;
    }

    public String getURI() {
        return this.uri;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getLength() {
        return this.length;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }
}

