/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.io.j2me.socket;

public class ProxyInitializer {
    public static final String INITIALIZER = "connect";
    public static final String SEPERATOR = " ";
    private String host;
    private String port;

    public ProxyInitializer(String host, String port) {
        this.host = host;
        this.port = port;
    }

    public ProxyInitializer(String initStr) throws IllegalArgumentException {
        int posPort;
        if (!initStr.startsWith("connect ")) {
            throw new IllegalArgumentException("Invalid initializer: should start with connect");
        }
        int posHost = initStr.indexOf(SEPERATOR);
        if (posHost == -1) {
            throw new IllegalArgumentException("Invalid initializer: \" \" expected to reperate INITIALIZER and hostname");
        }
        if ((posPort = initStr.indexOf(SEPERATOR, ++posHost)) == -1) {
            throw new IllegalArgumentException("Invalid initializer: \" \" expected to reperate hostname and port number");
        }
        this.host = initStr.substring(posHost, ++posPort - 1);
        this.port = initStr.substring(posPort);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortInt() {
        return Integer.parseInt(this.port);
    }

    public String toString() {
        return "connect " + this.host + SEPERATOR + this.port;
    }
}

