/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.io.j2me.socket;

import com.sun.spot.io.j2me.socket.ProxyInitializer;
import com.sun.spot.io.j2me.socket.SocketProtocolInputStream;
import com.sun.spot.io.j2me.socket.SocketProtocolOutputStream;
import com.sun.spot.peripheral.ITimeoutableConnection;
import com.sun.spot.peripheral.NoAckException;
import com.sun.spot.peripheral.TimeoutException;
import com.sun.spot.util.Utils;
import com.sun.squawk.Isolate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.StreamConnection;

public class SocketConnection {
    public static final String SOCKET_PROXY_BASE_STATION_ADDRESS_MANIFEST_PROPERTY = "com.sun.spot.io.j2me.socket.SocketConnection-BaseStationAddress";
    public static final String SOCKET_PROXY_BASE_STATION_PORT_MANIFEST_PROPERTY = "com.sun.spot.io.j2me.socket.SocketConnection-BaseStationPort";
    public static final String DEFAULT_BASE_STATION_PORT = "10";
    public static final int PACKET_TYPE_PORT_REQUEST = 0;
    public static final int PACKET_TYPE_PORT_RESPONSE = 1;
    private StreamConnection conn;
    private SocketOutputStream out = null;
    private SocketInputStream in = null;
    int opens = 0;
    private boolean connected = false;

    public SocketConnection(ProxyInitializer initializer, boolean timeouts) throws IllegalArgumentException, IOException {
        int port;
        String baseStationAddress = Utils.getManifestProperty(SOCKET_PROXY_BASE_STATION_ADDRESS_MANIFEST_PROPERTY, null);
        if (baseStationAddress == null && (baseStationAddress = Isolate.currentIsolate().getProperty(SOCKET_PROXY_BASE_STATION_ADDRESS_MANIFEST_PROPERTY)) == null) {
            baseStationAddress = "broadcast";
        }
        baseStationAddress = baseStationAddress.trim();
        String baseStationPort = Utils.getManifestProperty(SOCKET_PROXY_BASE_STATION_PORT_MANIFEST_PROPERTY, null);
        if (baseStationPort == null && (baseStationPort = Isolate.currentIsolate().getProperty(SOCKET_PROXY_BASE_STATION_PORT_MANIFEST_PROPERTY)) == null) {
            baseStationPort = DEFAULT_BASE_STATION_PORT;
        }
        baseStationPort = baseStationPort.trim();
        DatagramConnection initConnection = null;
        DatagramConnection initReceiveConnection = null;
        try {
            if (baseStationAddress.equals("broadcast")) {
                initReceiveConnection = (DatagramConnection)Connector.open((String)("radiogram://:" + baseStationPort), (int)3, (boolean)true);
                ((ITimeoutableConnection)initReceiveConnection).setTimeout(10000L);
            }
            initConnection = (DatagramConnection)Connector.open((String)("radiogram://" + baseStationAddress + ":" + baseStationPort), (int)3, (boolean)true);
            ((ITimeoutableConnection)initConnection).setTimeout(8000L);
            Datagram datagram = initConnection.newDatagram(initConnection.getMaximumLength());
            datagram.writeByte(0);
            datagram.writeUTF(initializer.toString());
            initConnection.send(datagram);
            do {
                if (initReceiveConnection != null) {
                    datagram = initReceiveConnection.newDatagram(initReceiveConnection.getMaximumLength());
                    initReceiveConnection.receive(datagram);
                    continue;
                }
                initConnection.receive(datagram);
            } while (datagram.readUnsignedByte() != 1);
            port = datagram.readInt();
            baseStationAddress = datagram.getAddress();
        }
        catch (TimeoutException te) {
            throw new IOException("unable to establish connection with socket proxy at address " + baseStationAddress + " on port " + baseStationPort + " (timeout)");
        }
        catch (NoAckException nae) {
            throw new IOException("unable to establish connection with socket proxy at address " + baseStationAddress + " on port " + baseStationPort + " (no ack)");
        }
        finally {
            if (initConnection != null) {
                initConnection.close();
            }
            if (initReceiveConnection != null) {
                initReceiveConnection.close();
            }
        }
        this.conn = (StreamConnection)Connector.open((String)("radiostream://" + baseStationAddress + ":" + port), (int)3, (boolean)timeouts);
        this.connected = true;
        ++this.opens;
    }

    public SocketInputStream getInputStream() throws IOException {
        if (this.in == null) {
            ++this.opens;
            this.in = new SocketInputStream(this.conn.openInputStream());
        }
        return this.in;
    }

    public SocketOutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            ++this.opens;
            this.out = new SocketOutputStream(this.conn.openOutputStream());
        }
        return this.out;
    }

    private void disconnect() throws IOException {
        if (this.connected) {
            if (this.in != null) {
                this.in.closeConnection();
                this.in = null;
            }
            if (this.out != null) {
                this.out.closeConnection();
                this.out = null;
            }
            this.conn.close();
            this.conn = null;
            this.connected = false;
        }
    }

    public void close() throws IOException {
        if (this.connected && --this.opens == 0) {
            this.disconnect();
        }
    }

    private class SocketOutputStream
    extends SocketProtocolOutputStream {
        private boolean opened = true;

        public SocketOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int data) throws IOException {
            if (!this.opened) {
                throw new IOException("outputstream is closed");
            }
            super.write(data);
        }

        public void flush() throws IOException {
            if (!this.opened) {
                throw new IOException("outputstream is closed");
            }
            super.flush();
        }

        public void close() throws IOException {
            if (this.opened) {
                this.opened = false;
                if (--SocketConnection.this.opens == 0) {
                    SocketConnection.this.disconnect();
                }
            }
        }

        private void closeConnection() throws IOException {
            super.close();
        }
    }

    private class SocketInputStream
    extends SocketProtocolInputStream {
        private boolean opened = true;

        public SocketInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            if (!this.opened) {
                throw new IOException("inputstream is closed");
            }
            return super.read();
        }

        public void close() throws IOException {
            if (this.opened) {
                this.opened = false;
                if (--SocketConnection.this.opens == 0) {
                    SocketConnection.this.disconnect();
                }
            }
        }

        private void closeConnection() throws IOException {
            super.close();
        }
    }
}

