/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.io.j2me.socket;

import com.sun.spot.io.j2me.socket.SpotSocketProtocol;
import java.io.IOException;
import java.io.InputStream;

public class SocketProtocolInputStream
extends InputStream
implements SpotSocketProtocol {
    private InputStream in;

    public SocketProtocolInputStream(InputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        int data = this.in.read();
        if (data == 255) {
            data = this.in.read();
            switch (data) {
                case 113: {
                    data = -1;
                    break;
                }
                case 101: {
                    throw new IOException(this.readProtocolString());
                }
                case 255: {
                    break;
                }
                default: {
                    throw new IOException("Unexpected escape character in protocol: " + data);
                }
            }
        }
        return data;
    }

    private String readProtocolString() throws IOException {
        int data;
        int size = 0;
        int shiftBy = 0;
        do {
            data = this.in.read();
            size = (data & 0x7F) << shiftBy | size;
            shiftBy += 7;
        } while ((data & 0x80) != 0);
        byte[] bytes = new byte[size];
        int read = this.in.read(bytes, 0, size);
        return new String(bytes, 0, read);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        super.close();
    }
}

