/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    private int length;
    private int count;
    private InputStream in;

    public BoundedInputStream(InputStream in) throws IOException {
        this.in = in;
        this.length = Math.max(new DataInputStream(in).readInt(), 0);
        this.count = 0;
    }

    public int read() throws IOException {
        if (this.count >= this.length) {
            return -1;
        }
        ++this.count;
        return this.in.read();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int available() throws IOException {
        return this.length - this.count;
    }
}

