/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral;

import com.sun.spot.peripheral.S29PL_Flash;
import com.sun.spot.util.Utils;

public class ConfigPage {
    private static final String MIDLET_MARKER_STRING = "-MIDlet-";
    public static final int MAX_MANUFACTURING_IMAGE_SIZE = S29PL_Flash.getCommonSize();
    public static final int FLASH_BASE_ADDRESS = 0x10000000;
    public static final int BOOTLOADER_ADDRESS = 0x10000000;
    public static final int FAT_SECTOR_NUMBER = 5;
    public static final int FAT_ADDRESS = S29PL_Flash.getCommonSectorAddress(5);
    public static final int VM_SECTOR_NUMBER = 8;
    public static final int VM_ADDRESS = S29PL_Flash.getCommonSectorAddress(8);
    public static final int BOOTSTRAP_SECTOR = 12;
    public static final int BOOTSTRAP_ADDRESS = S29PL_Flash.getCommonSectorAddress(12);
    public static final int FIRST_FILE_SYSTEM_SECTOR = 20;
    public static final int FIRST_FILE_SYSTEM_SECTOR_ADDRESS = S29PL_Flash.getCommonSectorAddress(20);
    public static final int LAST_COMMON_FILE_SYSTEM_SECTOR = S29PL_Flash.getCommonLastLargeSector();
    public static final int LAST_COMMON_FILE_SYSTEM_SECTOR_ADDRESS = S29PL_Flash.getCommonSectorAddress(LAST_COMMON_FILE_SYSTEM_SECTOR);
    public static final int TRUST_MANAGER_SECTOR = 7;
    public static final int SYSTEM_PROPERTIES_SECTOR = 6;
    public static final int CONFIG_PAGE_SECTOR = 4;
    public static final int CONFIG_PAGE_ADDRESS = S29PL_Flash.getCommonSectorAddress(4);
    public static final int DEFAULT_SECTOR_COUNT_FOR_RMS = 8;
    public static final int LARGE_SECTOR_SIZE = 65536;
    public static final String SPOT_SUITE_PROTOCOL_NAME = "spotsuite";
    public static final String LIBRARY_URI = "spotsuite://library";
    public static final int LIBRARY_VIRTUAL_ADDRESS = 0x10800000;
    private long targetID;
    private int configVersion;
    private int vmAddress;
    private byte flags;
    private String cmdLineParams;
    private String cmdLineAdminParams;
    private boolean wasLoaded;
    private byte[] publicKey;
    public static final int SERIAL_NUMBER_OFFSET = 0;
    public static final int CONFIG_VERSION_OFFSET = 8;
    public static final int FLAGS_OFFSET = 10;
    public static final int CMD_LINE_PARAMETERS_NORMAL_OFFSET = 12;
    public static final int CMD_LINE_PARAMETERS_ADMIN_OFFSET = 14;
    public static final int VM_ADDRESS_OFFSET = 16;
    public static final int PUBLIC_KEY_OFFSET = 20;
    public static final int STRINGS_OFFSET = 22;
    public static final int CONFIG_PAGE_SIZE = 1024;
    public static final int CURRENT_CONFIG_VERSION = 11;
    private static final String VM_PARAMETERS = "-Xboot:268763136 -Xmxnvm:0 -isolateinit:com.sun.spot.peripheral.Spot -dma:1024";
    public static final String INITIAL_COMMAND_LINE = "-spotsuite://library -Xboot:268763136 -Xmxnvm:0 -isolateinit:com.sun.spot.peripheral.Spot -dma:1024 com.sun.spot.util.DummyApp";
    public static final String INITIAL_ADMIN_COMMAND_LINE = "-spotsuite://library -Xboot:268763136 -Xmxnvm:0 -isolateinit:com.sun.spot.peripheral.Spot -dma:1024 -Dspot.start.manifest.daemons=false com.sun.spot.peripheral.ota.OTACommandProcessor";
    private static final byte SLOW_STARTUP_MASK = 1;

    public ConfigPage(byte[] rawConfigPage) {
        this.targetID = Utils.readLittleEndLong(rawConfigPage, 0);
        this.configVersion = Utils.readLittleEndShort(rawConfigPage, 8);
        if (this.configVersion == 11) {
            try {
                this.parseCurrentFormat(rawConfigPage);
            }
            catch (Exception e) {
                this.wasLoaded = false;
                this.initializeConfigPage();
            }
        } else {
            this.wasLoaded = false;
            this.initializeConfigPage();
        }
    }

    private void parseCurrentFormat(byte[] rawConfigPage) {
        this.wasLoaded = true;
        this.flags = rawConfigPage[10];
        this.vmAddress = Utils.readLittleEndInt(rawConfigPage, 16);
        this.cmdLineParams = this.getCmdLine(rawConfigPage, 12);
        this.cmdLineAdminParams = this.getCmdLine(rawConfigPage, 14);
        int strAddr = Utils.readLittleEndShort(rawConfigPage, 20);
        this.publicKey = new byte[Utils.readLittleEndShort(rawConfigPage, strAddr)];
        strAddr += 2;
        for (int i = 0; i < this.publicKey.length; ++i) {
            this.publicKey[i] = rawConfigPage[strAddr++];
        }
    }

    private String getCmdLine(byte[] rawConfigPage, int cmdStringOffsetAddress) {
        int paramsStartAddr;
        int paramsEndAddr = paramsStartAddr = Utils.readLittleEndShort(rawConfigPage, cmdStringOffsetAddress);
        while (rawConfigPage[paramsEndAddr] != 0 || rawConfigPage[paramsEndAddr + 1] != 0) {
            ++paramsEndAddr;
        }
        String result = new String(rawConfigPage, paramsStartAddr, paramsEndAddr - paramsStartAddr);
        result = result.replace('\u0000', ' ');
        return result;
    }

    public ConfigPage() {
        this.reset();
    }

    public byte[] asByteArray() {
        byte[] rawConfigPage = new byte[1024];
        Utils.writeLittleEndLong(rawConfigPage, 0, this.targetID);
        Utils.writeLittleEndShort(rawConfigPage, 8, this.configVersion);
        Utils.writeLittleEndInt(rawConfigPage, 16, this.vmAddress);
        rawConfigPage[10] = this.flags;
        int strAddr = 22;
        strAddr = this.insertCmdString(rawConfigPage, strAddr, 12, this.cmdLineParams);
        strAddr = this.insertCmdString(rawConfigPage, strAddr, 14, this.cmdLineAdminParams);
        Utils.writeLittleEndShort(rawConfigPage, 20, strAddr);
        Utils.writeLittleEndShort(rawConfigPage, strAddr, (short)this.publicKey.length);
        strAddr += 2;
        for (int i = 0; i < this.publicKey.length; ++i) {
            rawConfigPage[strAddr++] = this.publicKey[i];
        }
        return rawConfigPage;
    }

    private int insertCmdString(byte[] rawConfigPage, int strAddr, int cmdStringOffsetAddress, String cmdString) {
        Utils.writeLittleEndShort(rawConfigPage, cmdStringOffsetAddress, strAddr);
        String output = Utils.withSpacesReplacedByZeros(cmdString);
        for (int i = 0; i < output.length(); ++i) {
            rawConfigPage[strAddr++] = (byte)output.charAt(i);
        }
        rawConfigPage[strAddr++] = 0;
        rawConfigPage[strAddr++] = 0;
        return strAddr;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public long getTargetID() {
        return this.targetID;
    }

    public void setTargetID(long targetID) {
        this.targetID = targetID;
    }

    public String getCmdLineParams() {
        return this.cmdLineParams;
    }

    public String getAdminCmdLineParams() {
        return this.cmdLineAdminParams;
    }

    public void setCmdLineParams(String params) {
        this.cmdLineParams = params;
    }

    public void resetCmdLine(String uri) {
        this.setCmdLineParams("-" + uri + " " + VM_PARAMETERS + " -MIDlet-1");
    }

    public void resetCmdLine(String uri, String initialClass) {
        this.setCmdLineParams("-" + uri + " " + VM_PARAMETERS + " " + initialClass);
    }

    public void setAdminCmdLineParams(String params) {
        this.cmdLineAdminParams = params;
    }

    public int getBootstrapAddress() {
        return BOOTSTRAP_ADDRESS;
    }

    public int getVmAddress() {
        return this.vmAddress;
    }

    public void setVmAddress(int vmAddress) {
        this.vmAddress = vmAddress;
    }

    public int getBootloaderSpace() {
        return 32768;
    }

    public int getConfigSpace() {
        return 8192;
    }

    public int getVmSpace() {
        return this.getBootstrapAddress() - this.getVmAddress();
    }

    public int getBootstrapSpace() {
        return FIRST_FILE_SYSTEM_SECTOR_ADDRESS - this.getBootstrapAddress();
    }

    public int getManufacturingImageSpace() {
        return MAX_MANUFACTURING_IMAGE_SIZE;
    }

    public boolean wasLoaded() {
        return this.wasLoaded;
    }

    public void setWasLoaded(boolean b) {
        this.wasLoaded = b;
    }

    private void initializeConfigPage() {
        this.configVersion = 11;
        this.vmAddress = VM_ADDRESS;
        this.targetID = -1L;
        this.flags = 0;
        this.cmdLineParams = INITIAL_COMMAND_LINE;
        this.cmdLineAdminParams = INITIAL_ADMIN_COMMAND_LINE;
        this.publicKey = new byte[0];
    }

    public void setPublicKey(byte[] key) {
        this.publicKey = Utils.copy(key);
    }

    public byte[] getPublicKey() {
        return Utils.copy(this.publicKey);
    }

    public boolean isSlowStartup() {
        return this.getBitFlag((byte)1);
    }

    public void setSlowStartup(boolean startSlowly) {
        this.setBitFlag(startSlowly, (byte)1);
    }

    public void setStartup(String squawkArgs, String uri, String midletNumberOrMainClass) {
        this.setCmdLineParams("-" + uri + " " + squawkArgs + " " + midletNumberOrMainClass);
    }

    public String getStartupUri() {
        int startIndex = this.cmdLineParams.indexOf(SPOT_SUITE_PROTOCOL_NAME);
        int endIndex = this.cmdLineParams.indexOf(32, startIndex);
        return this.cmdLineParams.substring(startIndex, endIndex);
    }

    public void reset() {
        this.wasLoaded = false;
        this.initializeConfigPage();
    }

    private void setBitFlag(boolean value, byte mask) {
        this.flags = (byte)(this.flags & ~mask);
        if (value) {
            this.flags = (byte)(this.flags | mask);
        }
    }

    private boolean getBitFlag(byte mask) {
        return (this.flags & mask) != 0;
    }

    public boolean isRunningMidletOnStartup() {
        return this.cmdLineParams.indexOf(MIDLET_MARKER_STRING) >= 0;
    }

    public int getStartupMidlet() {
        if (!this.isRunningMidletOnStartup()) {
            throw new IllegalStateException("Attempt to read startup midlet number when SPOT is configured to run a class");
        }
        int startIndex = this.cmdLineParams.indexOf(MIDLET_MARKER_STRING) + MIDLET_MARKER_STRING.length();
        int endIndex = this.cmdLineParams.indexOf(32, startIndex);
        if (endIndex < 0) {
            endIndex = this.cmdLineParams.length();
        }
        return Integer.parseInt(this.cmdLineParams.substring(startIndex, endIndex));
    }

    public String getStartupClass() {
        if (this.isRunningMidletOnStartup()) {
            throw new IllegalStateException("Attempt to read startup class when SPOT is configured to run a midlet");
        }
        int startIndex = 0;
        String trimmedCmdLineParams = this.cmdLineParams.trim();
        while (trimmedCmdLineParams.charAt(startIndex) == '-') {
            startIndex = trimmedCmdLineParams.indexOf(32, startIndex) + 1;
        }
        int endIndex = this.cmdLineParams.indexOf(32, startIndex);
        if (endIndex < 0) {
            endIndex = this.cmdLineParams.length();
        }
        return this.cmdLineParams.substring(startIndex, endIndex);
    }
}

