/*
 * Decompiled with CFR 0.152.
 */
package com.sun.spot.peripheral;

import com.sun.spot.flashmanagement.IAddressableNorFlashSector;
import com.sun.spot.peripheral.IFlashMemoryDevice;
import com.sun.squawk.Address;
import com.sun.squawk.peripheral.INorFlashSector;

public class NorFlashSector
implements IAddressableNorFlashSector,
INorFlashSector {
    private int purpose;
    private int size;
    private int startAddress;
    private int virtualStartAddress;
    private IFlashMemoryDevice flashMem;
    private int sectorNumber;

    protected NorFlashSector() {
    }

    public NorFlashSector(IFlashMemoryDevice flashMem, int sectorNumber, int purpose) {
        this.flashMem = flashMem;
        this.sectorNumber = sectorNumber;
        this.startAddress = flashMem.getSectorAddress(sectorNumber);
        this.size = flashMem.getSectorSize(sectorNumber);
        this.purpose = purpose;
    }

    public void erase() {
        this.flashMem.eraseSectorAtAddress(this.startAddress);
    }

    public void getBytes(int memoryOffset, byte[] buffer, int bufferOffset, int length) {
        if (length == 0) {
            return;
        }
        this.ensureInBounds(memoryOffset, buffer, bufferOffset, length);
        this.flashMem.read(this.startAddress + memoryOffset, length, buffer, bufferOffset);
    }

    public byte getErasedValue() {
        return -1;
    }

    public int getPurpose() {
        return this.purpose;
    }

    public int getSize() {
        return this.size;
    }

    public Address getStartAddress() {
        return Address.fromPrimitive((int)this.startAddress);
    }

    public int getStartAddressAsInt() {
        return this.startAddress;
    }

    public int getVirtualStartAddressAsInt() {
        return this.virtualStartAddress;
    }

    public void setBytes(int memoryOffset, byte[] buffer, int bufferOffset, int length) {
        if (length == 0) {
            return;
        }
        if ((memoryOffset & 1) == 1) {
            throw new IndexOutOfBoundsException("memory offset must be even");
        }
        this.ensureInBounds(memoryOffset, buffer, bufferOffset, length);
        int pageSize = this.flashMem.getPageSize();
        int numPages = length / pageSize;
        int address = this.startAddress + memoryOffset;
        for (int i = 0; i < numPages; ++i) {
            this.flashMem.write(address, pageSize, buffer, bufferOffset);
            address += pageSize;
            bufferOffset += pageSize;
        }
        if (length % pageSize > 0) {
            this.flashMem.write(address, length % pageSize, buffer, bufferOffset);
        }
    }

    public int getSectorNumber() {
        return this.sectorNumber;
    }

    public void setVirtualAddress(int virtualAddress) {
        this.virtualStartAddress = virtualAddress;
    }

    void ensureInBounds(int memoryOffset, byte[] buffer, int bufferOffset, int length) {
        if (memoryOffset > this.size || memoryOffset < 0) {
            throw new IndexOutOfBoundsException("sectorSize: " + this.size + " memoryOffset: " + memoryOffset);
        }
        if (memoryOffset + length > this.size) {
            throw new IndexOutOfBoundsException("sectorSize: " + this.size + " memoryOffset: " + memoryOffset + " length: " + length);
        }
        int bufferSize = buffer.length;
        if (bufferOffset > bufferSize || bufferOffset < 0) {
            throw new IndexOutOfBoundsException("bufferSize: " + bufferSize + " bufferOffset: " + bufferOffset);
        }
        if (bufferOffset + length > bufferSize) {
            throw new IndexOutOfBoundsException("bufferSize: " + bufferSize + " bufferOffset: " + bufferOffset + " length: " + length);
        }
    }
}

